/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.reload;

import com.mojang.logging.LogUtils;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.preload.ResourcePreLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FancyMenuResourceReload {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DUMMY_RETURN = "FANCYMENU RESOURCE RELOAD LISTENER";
    private static final Map<Long, Runnable> LISTENERS = new HashMap<Long, Runnable>();
    private static long id = 0L;
    public static final ResourceLocation FANCYMENU_RELOAD_LISTENER_ID = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"fancymenu_reload_listener");

    public static long registerReloadListener(@NotNull Runnable runnable) {
        LISTENERS.put(++id, runnable);
        return id;
    }

    public static void removeReloadListener(long listenerId) {
        LISTENERS.remove(listenerId);
    }

    @ApiStatus.Internal
    @NotNull
    public static SimplePreparableReloadListener<String> createMinecraftPreparableReloadListener() {
        return new SimplePreparableReloadListener<String>(){

            @NotNull
            protected String prepare(@NotNull ResourceManager var1, @NotNull ProfilerFiller var2) {
                return FancyMenuResourceReload.DUMMY_RETURN;
            }

            protected void apply(@NotNull String prepareReturnValue, @NotNull ResourceManager var2, @NotNull ProfilerFiller var3) {
                LISTENERS.forEach((aLong, runnable) -> runnable.run());
            }
        };
    }

    static {
        FancyMenuResourceReload.registerReloadListener(ResourceHandlers::reloadAll);
        FancyMenuResourceReload.registerReloadListener(() -> ResourcePreLoader.preLoadAll(120000L));
    }
}

