/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import org.joml.Matrix3x2f;

public record FloatBlitRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f transform, float minX, float minY, float maxX, float maxY, float minU, float maxU, float minV, float maxV, int color, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
{
    public FloatBlitRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f transform, float minX, float minY, float maxX, float maxY, float minU, float maxU, float minV, float maxV, int color, @Nullable ScreenRectangle scissorRectangle) {
        this(pipeline, textureSetup, transform, minX, minY, maxX, maxY, minU, maxU, minV, maxV, color, scissorRectangle, FloatBlitRenderState.getBounds(minX, minY, maxX, maxY, transform, scissorRectangle));
    }

    public void buildVertices(VertexConsumer vertexConsumer) {
        vertexConsumer.addVertexWith2DPose(this.transform(), this.minX(), this.minY()).setUv(this.minU(), this.minV()).setColor(this.color());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.minX(), this.maxY()).setUv(this.minU(), this.maxV()).setColor(this.color());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.maxX(), this.maxY()).setUv(this.maxU(), this.maxV()).setColor(this.color());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.maxX(), this.minY()).setUv(this.maxU(), this.minV()).setColor(this.color());
    }

    @Nullable
    private static ScreenRectangle getBounds(float minX, float minY, float maxX, float maxY, Matrix3x2f transform, @Nullable ScreenRectangle scissorRectangle) {
        int x = (int)minX;
        int y = (int)minY;
        int width = (int)(maxX - minX);
        int height = (int)(maxY - minY);
        ScreenRectangle elementBounds = new ScreenRectangle(x, y, width, height).transformMaxBounds(transform);
        return scissorRectangle != null ? scissorRectangle.intersection(elementBounds) : elementBounds;
    }
}

