/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.toast;

import de.keksuccino.fancymenu.util.rendering.ui.toast.SimpleToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ToastHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void showToast(@NotNull SimpleToast toast, long durationMs) {
        long start = System.currentTimeMillis();
        Minecraft.getInstance().getToastManager().addToast((Toast)toast);
        new Thread(() -> {
            try {
                while (true) {
                    long now;
                    if (start + durationMs < (now = System.currentTimeMillis())) {
                        toast.hide();
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                try {
                    toast.hide();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.error("[FANCYMENU] Error in timer thread of SimpleToast in ToastHandler!", (Throwable)ex);
            }
        }).start();
    }
}

