/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinRealmsNotificationsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RealmsNotificationRenderer {
    private static final ResourceLocation UNSEEN_NOTIFICATION_SPRITE = ResourceLocation.withDefaultNamespace((String)"icon/unseen_notification");
    private static final ResourceLocation NEWS_SPRITE = ResourceLocation.withDefaultNamespace((String)"icon/news");
    private static final ResourceLocation INVITE_SPRITE = ResourceLocation.withDefaultNamespace((String)"icon/invite");
    private static final ResourceLocation TRIAL_AVAILABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"icon/trial_available");
    private final IMixinRealmsNotificationsScreen screenAccess;
    private final Minecraft minecraft;
    private final int screenWidth;
    private final int screenHeight;

    public RealmsNotificationRenderer(@NotNull RealmsNotificationsScreen screen, int screenWidth, int screenHeight) {
        this.screenAccess = (IMixinRealmsNotificationsScreen)screen;
        this.minecraft = Minecraft.getInstance();
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public int getDefaultPositionX() {
        int originalRightPosition = this.screenWidth / 2 + 100 - 3;
        return originalRightPosition - this.getTotalWidth();
    }

    public int getDefaultPositionY() {
        int k = this.screenHeight / 4 + 48;
        return k + 48 + 2;
    }

    public int getTotalWidth() {
        int iconCount = 0;
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        if (hasUnseenNotifications) {
            ++iconCount;
        }
        if (showOldNotifications) {
            if (hasUnreadNews) {
                ++iconCount;
            }
            if (pendingInvites > 0) {
                ++iconCount;
            }
            if (trialAvailable) {
                ++iconCount;
            }
        }
        return iconCount > 0 ? (iconCount - 1) * 16 + 14 : 0;
    }

    public int getTotalHeight() {
        return 18;
    }

    public void renderIcons(GuiGraphics guiGraphics, int x, int y, int color) {
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        int currentX = x;
        if (trialAvailable && showOldNotifications) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TRIAL_AVAILABLE_SPRITE, currentX, y + 4, 8, 8, color);
            currentX += 16;
        }
        if (pendingInvites > 0 && showOldNotifications) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, INVITE_SPRITE, currentX, y + 1, 14, 14, color);
            currentX += 16;
        }
        if (hasUnreadNews && showOldNotifications) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, NEWS_SPRITE, currentX, y + 1, 14, 14, color);
            currentX += 16;
        }
        if (hasUnseenNotifications) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, UNSEEN_NOTIFICATION_SPRITE, currentX, y + 3, 10, 10, color);
        }
    }

    public void renderIcons(GuiGraphics guiGraphics, int color) {
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu().getNow(false);
        if (isValidClient) {
            this.renderIcons(guiGraphics, this.getDefaultPositionX(), this.getDefaultPositionY(), color);
        }
    }

    public boolean shouldShowOldNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu().getNow(false);
        boolean inTitleScreen = this.minecraft.screen instanceof TitleScreen;
        if (!isValidClient || !inTitleScreen) {
            return false;
        }
        return (Boolean)this.minecraft.options.realmsNotifications().get();
    }

    public int getNumberOfPendingInvites() {
        if (RealmsNotificationRenderer.isEditor()) {
            return 1;
        }
        return this.screenAccess.get_numberOfPendingInvites_FancyMenu();
    }

    public boolean hasUnseenNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnseenNotifications();
    }

    public boolean hasUnreadNews() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnreadNews_FancyMenu();
    }

    public boolean isTrialAvailable() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_trialAvailable_FancyMenu();
    }

    protected static boolean isEditor() {
        return Minecraft.getInstance().screen instanceof LayoutEditorScreen;
    }
}

