/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.texture.fma;

import com.mojang.blaze3d.platform.NativeImage;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.ThreadUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.texture.fma.FmaDecoder;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FmaTexture
implements ITexture,
PlayableResource {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected volatile List<FmaFrame> frames = new ArrayList<FmaFrame>();
    @NotNull
    protected volatile List<FmaFrame> introFrames = new ArrayList<FmaFrame>();
    @Nullable
    protected volatile FmaFrame current = null;
    protected volatile boolean introFinishedPlaying = false;
    protected volatile boolean skipToFirstNormalAfterIntro = false;
    @NotNull
    protected volatile AspectRatio aspectRatio = new AspectRatio(10, 10);
    protected volatile int width = 10;
    protected volatile int height = 10;
    protected volatile long lastResourceLocationCall = -1L;
    protected final AtomicBoolean tickerThreadRunning = new AtomicBoolean(false);
    protected final AtomicBoolean decoded = new AtomicBoolean(false);
    protected volatile boolean allFramesDecoded = false;
    protected volatile boolean allIntroFramesDecoded = false;
    protected final AtomicInteger cycles = new AtomicInteger(0);
    protected final AtomicInteger numPlays = new AtomicInteger(0);
    protected ResourceLocation sourceLocation;
    protected File sourceFile;
    protected String sourceURL;
    protected final AtomicBoolean loadingCompleted = new AtomicBoolean(false);
    protected final AtomicBoolean loadingFailed = new AtomicBoolean(false);
    protected final String uniqueId = ScreenCustomization.generateUniqueIdentifier();
    protected int frameRegistrationCounter = 0;
    protected volatile boolean maxLoopsReached = false;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    @NotNull
    public static FmaTexture location(@NotNull ResourceLocation location) {
        return FmaTexture.location(location, null);
    }

    @NotNull
    public static FmaTexture location(@NotNull ResourceLocation location, @Nullable FmaTexture writeTo) {
        Objects.requireNonNull(location);
        FmaTexture texture = writeTo != null ? writeTo : new FmaTexture();
        texture.sourceLocation = location;
        try {
            FmaTexture.of(Minecraft.getInstance().getResourceManager().open(location), location.toString(), texture);
        }
        catch (Exception ex) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read FMA image from ResourceLocation: " + String.valueOf(location), (Throwable)ex);
        }
        return texture;
    }

    @NotNull
    public static FmaTexture local(@NotNull File fmaFile) {
        return FmaTexture.local(fmaFile, null);
    }

    @NotNull
    public static FmaTexture local(@NotNull File fmaFile, @Nullable FmaTexture writeTo) {
        Objects.requireNonNull(fmaFile);
        FmaTexture texture = writeTo != null ? writeTo : new FmaTexture();
        texture.sourceFile = fmaFile;
        if (!fmaFile.isFile()) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read FMA image from file! File not found: " + fmaFile.getPath());
            return texture;
        }
        new Thread(() -> {
            try {
                FileInputStream in = new FileInputStream(fmaFile);
                FmaTexture.of(in, fmaFile.getPath(), texture);
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to read FMA image from file: " + fmaFile.getPath(), (Throwable)ex);
            }
        }).start();
        return texture;
    }

    @NotNull
    public static FmaTexture web(@NotNull String fmaUrl) {
        return FmaTexture.web(fmaUrl, null);
    }

    @NotNull
    public static FmaTexture web(@NotNull String fmaUrl, @Nullable FmaTexture writeTo) {
        Objects.requireNonNull(fmaUrl);
        FmaTexture texture = writeTo != null ? writeTo : new FmaTexture();
        texture.sourceURL = fmaUrl;
        if (!TextValidators.BASIC_URL_TEXT_VALIDATOR.get(Objects.requireNonNull(fmaUrl)).booleanValue()) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read FMA image from URL! Invalid URL: " + fmaUrl);
            return texture;
        }
        new Thread(() -> {
            InputStream in = null;
            ByteArrayInputStream byteIn = null;
            try {
                in = WebUtils.openResourceStream(fmaUrl);
                if (in == null) {
                    throw new NullPointerException("Web resource input stream was NULL!");
                }
                byteIn = new ByteArrayInputStream(in.readAllBytes());
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to read FMA image from URL: " + fmaUrl, (Throwable)ex);
            }
            if (byteIn != null) {
                FmaTexture.of(byteIn, fmaUrl, texture);
            }
            CloseableUtils.closeQuietly(in);
        }).start();
        return texture;
    }

    @NotNull
    public static FmaTexture of(@NotNull InputStream in, @Nullable String gifTextureName, @Nullable FmaTexture writeTo) {
        Objects.requireNonNull(in);
        FmaTexture texture = writeTo != null ? writeTo : new FmaTexture();
        new Thread(() -> {
            FmaTexture.populateTexture(texture, in, gifTextureName != null ? gifTextureName : "[Generic InputStream Source]");
            if (texture.closed.get()) {
                MainThreadTaskExecutor.executeInMainThread(texture::close, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            }
        }).start();
        return texture;
    }

    @NotNull
    public static FmaTexture of(@NotNull InputStream in) {
        return FmaTexture.of(in, null, null);
    }

    protected static void populateTexture(@NotNull FmaTexture texture, @NotNull InputStream in, @NotNull String fmaTextureName) {
        DecodedFmaImage decodedImage = null;
        if (!texture.closed.get()) {
            decodedImage = FmaTexture.decodeFma(in, fmaTextureName);
            if (decodedImage == null) {
                LOGGER.error("[FANCYMENU] Failed to read FMA image, because DecodedFmaImage was NULL: " + fmaTextureName);
                texture.decoded.set(true);
                texture.loadingFailed.set(true);
                return;
            }
            texture.width = decodedImage.imageWidth;
            texture.height = decodedImage.imageHeight;
            texture.aspectRatio = new AspectRatio(decodedImage.imageWidth, decodedImage.imageHeight);
            texture.numPlays.set(decodedImage.numPlays);
            texture.decoded.set(true);
            try {
                if (decodedImage.decoder().hasIntroFrames()) {
                    FmaTexture.deliverFmaIntroFrames(decodedImage.decoder(), fmaTextureName, frame -> {
                        if (frame != null) {
                            try {
                                frame.nativeImage = NativeImage.read((InputStream)frame.frameInputStream);
                            }
                            catch (Exception ex) {
                                LOGGER.error("[FANCYMENU] Failed to read intro frame of FMA image into NativeImage: " + fmaTextureName, (Throwable)ex);
                            }
                            CloseableUtils.closeQuietly(frame.frameInputStream);
                            texture.introFrames.add((FmaFrame)frame);
                        }
                    });
                }
                texture.allIntroFramesDecoded = true;
                FmaTexture.deliverFmaFrames(decodedImage.decoder(), fmaTextureName, frame -> {
                    if (frame != null) {
                        try {
                            frame.nativeImage = NativeImage.read((InputStream)frame.frameInputStream);
                        }
                        catch (Exception ex) {
                            LOGGER.error("[FANCYMENU] Failed to read frame of FMA image into NativeImage: " + fmaTextureName, (Throwable)ex);
                        }
                        CloseableUtils.closeQuietly(frame.frameInputStream);
                        texture.frames.add((FmaFrame)frame);
                    }
                });
                texture.loadingCompleted.set(true);
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to read frames of FMA image: " + fmaTextureName, (Throwable)ex);
            }
            texture.allFramesDecoded = true;
            texture.allIntroFramesDecoded = true;
        }
        texture.decoded.set(true);
        CloseableUtils.closeQuietly(in);
        if (decodedImage != null) {
            CloseableUtils.closeQuietly(decodedImage.decoder());
        }
    }

    protected FmaTexture() {
    }

    protected void startTickerIfNeeded() {
        if (!(this.tickerThreadRunning.get() || this.frames.isEmpty() && this.introFrames.isEmpty() || this.maxLoopsReached || this.closed.get())) {
            this.tickerThreadRunning.set(true);
            this.lastResourceLocationCall = System.currentTimeMillis();
            new Thread(() -> {
                while (!(this.lastResourceLocationCall + 10000L <= System.currentTimeMillis() || this.frames.isEmpty() && this.introFrames.isEmpty() || this.closed.get() || this.maxLoopsReached)) {
                    boolean sleep = false;
                    try {
                        boolean cachedAllDecoded = this.allFramesDecoded;
                        boolean cachedAllIntroDecoded = this.allIntroFramesDecoded;
                        boolean cachedIntroFinished = this.introFinishedPlaying;
                        boolean cachedSkipToFirstAfterIntro = this.skipToFirstNormalAfterIntro;
                        ArrayList<FmaFrame> cachedFrames = new ArrayList<FmaFrame>(this.frames);
                        ArrayList<FmaFrame> cachedIntroFrames = new ArrayList<FmaFrame>(this.introFrames);
                        if (!cachedFrames.isEmpty() || !cachedIntroFrames.isEmpty()) {
                            if (this.current == null) {
                                FmaFrame first;
                                this.current = first = !cachedIntroFrames.isEmpty() ? (FmaFrame)cachedIntroFrames.get(0) : (FmaFrame)cachedFrames.get(0);
                                Thread.sleep(Math.max(10L, first.delayMs));
                            } else if (cachedSkipToFirstAfterIntro) {
                                FmaFrame firstNormal;
                                if (cachedFrames.isEmpty()) {
                                    ThreadUtils.sleep(100L);
                                    continue;
                                }
                                this.skipToFirstNormalAfterIntro = false;
                                this.current = firstNormal = (FmaFrame)cachedFrames.get(0);
                                Thread.sleep(Math.max(10L, firstNormal.delayMs));
                            }
                            FmaFrame cachedCurrent = this.current;
                            if (cachedCurrent != null) {
                                boolean pickNextIntroFrame;
                                FmaFrame newCurrent = null;
                                int currentIndexIncrement = cachedCurrent.index + 1;
                                boolean bl = pickNextIntroFrame = currentIndexIncrement < cachedIntroFrames.size() && !cachedIntroFinished;
                                if (!pickNextIntroFrame && !cachedIntroFinished && !cachedSkipToFirstAfterIntro && cachedAllIntroDecoded) {
                                    this.introFinishedPlaying = true;
                                    this.skipToFirstNormalAfterIntro = true;
                                    continue;
                                }
                                if (pickNextIntroFrame || currentIndexIncrement < cachedFrames.size()) {
                                    newCurrent = pickNextIntroFrame ? (FmaFrame)cachedIntroFrames.get(currentIndexIncrement) : (FmaFrame)cachedFrames.get(currentIndexIncrement);
                                } else if (cachedAllDecoded) {
                                    int cachedNumPlays = this.numPlays.get();
                                    if (cachedNumPlays > 0) {
                                        int newCycles = this.cycles.incrementAndGet();
                                        if (newCycles >= cachedNumPlays) {
                                            this.maxLoopsReached = true;
                                            break;
                                        }
                                        newCurrent = (FmaFrame)cachedFrames.get(0);
                                    } else {
                                        newCurrent = (FmaFrame)cachedFrames.get(0);
                                    }
                                }
                                if (newCurrent != null) {
                                    this.current = newCurrent;
                                }
                                Thread.sleep(Math.max(10L, newCurrent != null ? newCurrent.delayMs : 100L));
                            } else {
                                sleep = true;
                            }
                        } else {
                            sleep = true;
                        }
                    }
                    catch (Exception ex) {
                        sleep = true;
                        LOGGER.error("[FANCYMENU] An error happened in the frame ticker thread of an FMA texture!", (Throwable)ex);
                    }
                    if (!sleep) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        LOGGER.error("[FANCYMENU] An error happened in the frame ticker thread of an FMA texture!", (Throwable)ex);
                    }
                }
                this.tickerThreadRunning.set(false);
            }).start();
        }
    }

    @Override
    @Nullable
    public ResourceLocation getResourceLocation() {
        if (this.closed.get()) {
            return FULLY_TRANSPARENT_TEXTURE;
        }
        this.lastResourceLocationCall = System.currentTimeMillis();
        this.startTickerIfNeeded();
        FmaFrame frame = this.current;
        if (frame != null) {
            if (frame.resourceLocation == null && !frame.loaded && frame.nativeImage != null) {
                try {
                    ++this.frameRegistrationCounter;
                    frame.dynamicTexture = new DynamicTexture(() -> UUID.randomUUID().toString(), frame.nativeImage);
                    frame.resourceLocation = RenderUtils.register((String)("fancymenu_fma_frame_" + this.uniqueId + "_" + this.frameRegistrationCounter), (AbstractTexture)frame.dynamicTexture);
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Failed to register FMA frame to Minecraft's TextureManager!", (Throwable)ex);
                }
                frame.loaded = true;
            }
            return frame.resourceLocation != null ? frame.resourceLocation : FULLY_TRANSPARENT_TEXTURE;
        }
        return null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        if (this.sourceURL != null) {
            return WebUtils.openResourceStream(this.sourceURL);
        }
        if (this.sourceFile != null) {
            return new FileInputStream(this.sourceFile);
        }
        if (this.sourceLocation != null) {
            return Minecraft.getInstance().getResourceManager().open(this.sourceLocation);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.decoded.get();
    }

    @Override
    public boolean isLoadingCompleted() {
        return !this.closed.get() && !this.loadingFailed.get() && this.loadingCompleted.get();
    }

    @Override
    public boolean isLoadingFailed() {
        return this.loadingFailed.get();
    }

    @Override
    public void reset() {
        this.maxLoopsReached = false;
        this.introFinishedPlaying = false;
        this.skipToFirstNormalAfterIntro = false;
        this.current = null;
        ArrayList<FmaFrame> normalFrames = new ArrayList<FmaFrame>(this.frames);
        ArrayList<FmaFrame> introFrames = new ArrayList<FmaFrame>(this.introFrames);
        if (!introFrames.isEmpty()) {
            this.current = (FmaFrame)introFrames.get(0);
        } else if (!normalFrames.isEmpty()) {
            this.current = (FmaFrame)normalFrames.get(0);
        }
        this.cycles.set(0);
    }

    @Override
    public void play() {
    }

    @Override
    public boolean isPlaying() {
        return !this.maxLoopsReached;
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void stop() {
        this.reset();
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.sourceLocation = null;
        for (FmaFrame frame : new ArrayList<FmaFrame>(this.frames)) {
            try {
                if (frame.dynamicTexture != null) {
                    frame.dynamicTexture.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close DynamicTexture of FMA frame!", (Throwable)ex);
            }
            try {
                if (frame.nativeImage != null) {
                    frame.nativeImage.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close NativeImage of FMA frame!", (Throwable)ex);
            }
            frame.dynamicTexture = null;
            frame.nativeImage = null;
        }
        for (FmaFrame frame : new ArrayList<FmaFrame>(this.introFrames)) {
            try {
                if (frame.dynamicTexture != null) {
                    frame.dynamicTexture.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close DynamicTexture of FMA intro frame!", (Throwable)ex);
            }
            try {
                if (frame.nativeImage != null) {
                    frame.nativeImage.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close NativeImage of FMA intro frame!", (Throwable)ex);
            }
            frame.dynamicTexture = null;
            frame.nativeImage = null;
        }
        this.frames = new ArrayList<FmaFrame>();
        this.introFrames = new ArrayList<FmaFrame>();
        this.current = null;
    }

    @Nullable
    public static DecodedFmaImage decodeFma(@NotNull InputStream in, @NotNull String fmaName) {
        try {
            FmaDecoder decoder = new FmaDecoder();
            decoder.read(in);
            BufferedImage firstFrame = Objects.requireNonNull(decoder.getFirstFrameAsBufferedImage(), "Failed to get first frame of FMA image!");
            return new DecodedFmaImage(decoder, firstFrame.getWidth(), firstFrame.getHeight(), Objects.requireNonNull(decoder.getMetadata(), "FmaDecoder returned NULL for metadata!").getLoopCount());
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to decode FMA image: " + fmaName, (Throwable)ex);
            return null;
        }
    }

    public static void deliverFmaFrames(@NotNull FmaDecoder decoder, @NotNull String fmaName, @NotNull Consumer<FmaFrame> frameDelivery) {
        int gifFrameCount = decoder.getFrameCount();
        int index = 0;
        for (int i = 0; i < gifFrameCount; ++i) {
            try {
                long delay = Objects.requireNonNull(decoder.getMetadata(), "FmaDecoder returned NULL for metadata!").getFrameTimeForFrame(i, false);
                InputStream image = Objects.requireNonNull(decoder.getFrame(i), "FmaDecoder returned NULL for frame!");
                frameDelivery.accept(new FmaFrame(index, image, delay));
                ++index;
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to get frame '" + i + "' of FMA image '" + fmaName + "!", (Throwable)ex);
            }
        }
    }

    public static void deliverFmaIntroFrames(@NotNull FmaDecoder decoder, @NotNull String fmaName, @NotNull Consumer<FmaFrame> frameDelivery) {
        if (!decoder.hasIntroFrames()) {
            return;
        }
        int gifFrameCount = decoder.getIntroFrameCount();
        int index = 0;
        for (int i = 0; i < gifFrameCount; ++i) {
            try {
                long delay = Objects.requireNonNull(decoder.getMetadata(), "FmaDecoder returned NULL for metadata!").getFrameTimeForFrame(i, true);
                InputStream image = Objects.requireNonNull(decoder.getIntroFrame(i), "FmaDecoder returned NULL for intro frame!");
                frameDelivery.accept(new FmaFrame(index, image, delay));
                ++index;
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to get intro frame '" + i + "' of FMA image '" + fmaName + "!", (Throwable)ex);
            }
        }
    }

    public record DecodedFmaImage(@NotNull FmaDecoder decoder, int imageWidth, int imageHeight, int numPlays) {
    }

    public static class FmaFrame {
        protected final int index;
        protected final InputStream frameInputStream;
        protected final long delayMs;
        protected DynamicTexture dynamicTexture;
        protected volatile NativeImage nativeImage;
        protected ResourceLocation resourceLocation;
        protected boolean loaded = false;

        protected FmaFrame(int index, InputStream frameInputStream, long delayMs) {
            this.index = index;
            this.frameInputStream = frameInputStream;
            this.delayMs = delayMs;
        }
    }
}

