/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.opengui.OpenGuiCommandPacket;
import de.keksuccino.fancymenu.util.CommandUtils;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class OpenGuiScreenCommand {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)Commands.literal((String)"openguiscreen").then(((RequiredArgumentBuilder)Commands.argument((String)"screen_identifier", (ArgumentType)StringArgumentType.string()).executes(stack -> OpenGuiScreenCommand.openGui((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"screen_identifier"), null))).suggests((context, provider) -> CommandUtils.buildStringSuggestionsList((CommandContext<CommandSourceStack>)context, "<screen_identifier>")).then(((RequiredArgumentBuilder)Commands.argument((String)"target_players", (ArgumentType)EntityArgument.players()).requires(stack -> stack.hasPermission(2))).executes(stack -> OpenGuiScreenCommand.openGui((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"screen_identifier"), EntityArgument.getPlayers((CommandContext)stack, (String)"target_players"))))));
    }

    private static int openGui(CommandSourceStack stack, String menuIdentifierOrCustomGuiName, @Nullable Collection<ServerPlayer> targets) {
        try {
            if (targets == null) {
                ServerPlayer sender = stack.getPlayerOrException();
                OpenGuiCommandPacket packet = new OpenGuiCommandPacket();
                packet.screen_identifier = menuIdentifierOrCustomGuiName;
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (ServerPlayer target : targets) {
                    OpenGuiCommandPacket packet = new OpenGuiCommandPacket();
                    packet.screen_identifier = menuIdentifierOrCustomGuiName;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        }
        catch (Exception ex) {
            stack.sendFailure((Component)Component.literal((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

