/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisconnectAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public DisconnectAction() {
        super("disconnect_server_or_world");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            Minecraft mc = Minecraft.getInstance();
            try {
                Screen current = Minecraft.getInstance().screen;
                if (current == null) {
                    current = new TitleScreen();
                }
                mc.getReportingContext().draftReportHandled(mc, current, () -> {
                    if (mc.level != null && mc.player != null) {
                        boolean isSinglePlayer = mc.isLocalServer();
                        Screen openAfter = CustomGuiHandler.guiExists(value) ? CustomGuiHandler.constructInstance(value, null, null) : ScreenInstanceFactory.tryConstruct(ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(value));
                        if (openAfter == null) {
                            openAfter = new TitleScreen();
                        }
                        mc.level.disconnect((Component)Component.empty());
                        if (isSinglePlayer) {
                            mc.disconnectWithSavingScreen();
                        } else {
                            mc.disconnectWithProgressScreen();
                        }
                        mc.setScreen(openAfter);
                    }
                }, true);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to execute Disconnect action!", (Throwable)ex);
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.editor.custombutton.config.actiontype.disconnect");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.disconnect.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.translatable((String)"fancymenu.editor.custombutton.config.actiontype.disconnect.desc.value");
    }

    @Override
    public String getValueExample() {
        return "example.menu.identifier";
    }
}

