/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.world.LastWorldHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinServerList;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinLastWorldServerAction
extends Action {
    public JoinLastWorldServerAction() {
        super("join_last_world");
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public void execute(@Nullable String value) {
        if (!LastWorldHandler.getLastWorld().isEmpty() && Minecraft.getInstance().screen != null) {
            if (!LastWorldHandler.isLastWorldServer()) {
                File f = new File(LastWorldHandler.getLastWorld());
                if (Minecraft.getInstance().getLevelSource().levelExists(f.getName())) {
                    Screen current = Minecraft.getInstance().screen != null ? Minecraft.getInstance().screen : new TitleScreen();
                    Minecraft.getInstance().setScreen((Screen)new GenericMessageScreen((Component)Component.translatable((String)"selectWorld.data_read")));
                    Minecraft.getInstance().createWorldOpenFlows().openWorld(f.getName(), () -> Minecraft.getInstance().setScreen(current));
                }
            } else {
                String ipRaw;
                String ip = ipRaw = LastWorldHandler.getLastWorld().replace(" ", "");
                int port = 25565;
                if (ip.contains(":")) {
                    String portString = ip.split(":", 2)[1];
                    ip = ip.split(":", 2)[0];
                    if (MathUtils.isInteger((String)portString)) {
                        port = Integer.parseInt(portString);
                    }
                }
                ServerData d = null;
                ServerList l = new ServerList(Minecraft.getInstance());
                l.load();
                for (ServerData data : ((IMixinServerList)l).getServerListFancyMenu()) {
                    if (!data.ip.equals(ipRaw)) continue;
                    d = data;
                    break;
                }
                if (d == null) {
                    d = new ServerData(ipRaw, ipRaw, ServerData.Type.OTHER);
                    l.add(d, false);
                    l.save();
                }
                boolean isQuickPlay = false;
                ConnectScreen.startConnecting((Screen)Minecraft.getInstance().screen, (Minecraft)Minecraft.getInstance(), (ServerAddress)new ServerAddress(ip, port), (ServerData)d, (boolean)isQuickPlay, null);
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.editor.custombutton.config.actiontype.join_last_world");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.join_last_world.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return null;
    }

    @Override
    public String getValueExample() {
        return null;
    }
}

