/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.inputfield;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.inputfield.InputFieldEditorElement;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputFieldElement
extends AbstractElement {
    public String linkedVariable;
    public InputFieldType type = InputFieldType.TEXT;
    public int maxTextLength = 10000;
    public ExtendedEditBox editBox;
    public String lastValue = "";
    public boolean navigatable = true;

    public InputFieldElement(ElementBuilder<InputFieldElement, InputFieldEditorElement> builder) {
        super(builder);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            if (InputFieldElement.isEditor()) {
                this.editBox.active = false;
                this.editBox.setEditable(false);
                if (this.linkedVariable != null && VariableHandler.variableExists(this.linkedVariable)) {
                    String var = Objects.requireNonNull(VariableHandler.getVariable(this.linkedVariable)).getValue();
                    this.editBox.setValue(var);
                }
            }
            this.editBox.setNavigatable(this.navigatable);
            this.editBox.setX(this.getAbsoluteX());
            this.editBox.setY(this.getAbsoluteY());
            this.editBox.setWidth(this.getAbsoluteWidth());
            ((IMixinAbstractWidget)((Object)this.editBox)).setHeightFancyMenu(this.getAbsoluteHeight());
            this.editBox.render(graphics, mouseX, mouseY, partial);
            if (!InputFieldElement.isEditor()) {
                if (this.linkedVariable != null) {
                    if (!this.lastValue.equals(this.editBox.getValue())) {
                        VariableHandler.setVariable(this.linkedVariable, this.editBox.getValue());
                    }
                    if (VariableHandler.variableExists(this.linkedVariable)) {
                        String val = Objects.requireNonNull(VariableHandler.getVariable(this.linkedVariable)).getValue();
                        if (!this.editBox.getValue().equals(val)) {
                            this.editBox.setValue(val);
                        }
                    } else {
                        this.editBox.setValue("");
                    }
                }
                this.lastValue = this.editBox.getValue();
            }
        }
    }

    @Override
    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        return ListUtils.of(this.editBox);
    }

    public static enum InputFieldType {
        INTEGER_ONLY("integer", CharacterFilter.buildIntegerFiler()),
        DECIMAL_ONLY("decimal", CharacterFilter.buildDecimalFiler()),
        URL("url", CharacterFilter.buildUrlFilter()),
        TEXT("text", null);

        final String name;
        final CharacterFilter filter;

        private InputFieldType(String name, CharacterFilter filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public CharacterFilter getFilter() {
            return this.filter;
        }

        public static InputFieldType getByName(String name) {
            for (InputFieldType i : InputFieldType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

