/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.splash;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.splash.SplashTextElementBuilder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSplashRenderer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplashTextElement
extends AbstractElement {
    public SourceMode sourceMode = SourceMode.DIRECT_TEXT;
    public String source = "Splash Text";
    @Nullable
    public ResourceSupplier<IText> textFileSupplier;
    public float scale = 1.0f;
    public boolean shadow = true;
    public boolean bounce = true;
    public float rotation = 20.0f;
    public DrawableColor baseColor = DrawableColor.of(new Color(255, 255, 0));
    public boolean refreshOnMenuReload = false;
    public Font font;
    protected float baseScale;
    protected String renderText;
    protected String lastSource;
    protected SourceMode lastSourceMode;
    protected boolean refreshedOnMenuLoad;

    public SplashTextElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = Minecraft.getInstance().font;
        this.baseScale = 1.8f;
        this.renderText = null;
        this.lastSource = null;
        this.lastSourceMode = null;
        this.refreshedOnMenuLoad = false;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            this.updateSplash();
            this.renderSplash(graphics);
        }
    }

    public void refresh() {
        this.getBuilder().splashCache.remove(this.getInstanceIdentifier());
        this.renderText = null;
    }

    protected void updateSplash() {
        if (SplashTextElement.isEditor()) {
            if (!Objects.equals(this.lastSource, this.source) || !Objects.equals((Object)this.lastSourceMode, (Object)this.sourceMode)) {
                this.refresh();
            }
            this.lastSource = this.source;
            this.lastSourceMode = this.sourceMode;
        }
        if (this.sourceMode != SourceMode.VANILLA && this.source == null) {
            return;
        }
        if (this.getBuilder().isNewMenu && this.refreshOnMenuReload && !this.refreshedOnMenuLoad) {
            this.refresh();
            this.refreshedOnMenuLoad = true;
        }
        if (this.renderText == null && this.getBuilder().splashCache.containsKey(this.getInstanceIdentifier())) {
            this.renderText = this.getBuilder().splashCache.get((Object)this.getInstanceIdentifier()).renderText;
        }
        if (this.renderText == null) {
            List<String> l;
            IText text;
            if (this.sourceMode == SourceMode.VANILLA) {
                SplashRenderer splashRenderer = Minecraft.getInstance().getSplashManager().getSplash();
                String string = this.renderText = splashRenderer != null ? ((IMixinSplashRenderer)splashRenderer).getSplashFancyMenu() : "";
            }
            if (this.sourceMode == SourceMode.TEXT_FILE && this.textFileSupplier != null && (text = this.textFileSupplier.get()) != null && (l = text.getTextLines()) != null) {
                if (!(l.isEmpty() || l.size() <= 1 && l.get(0).trim().isEmpty())) {
                    int i = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                    this.renderText = l.get(i);
                } else {
                    this.renderText = "\u00a7cERROR: SPLASH FILE IS EMPTY";
                }
            }
            if (this.sourceMode == SourceMode.DIRECT_TEXT) {
                this.renderText = this.source;
            }
        }
        this.getBuilder().splashCache.put(this.getInstanceIdentifier(), this);
    }

    protected void renderSplash(GuiGraphics graphics) {
        if (this.renderText == null) {
            if (SplashTextElement.isEditor()) {
                this.renderText = "< empty splash element >";
            } else {
                return;
            }
        }
        MutableComponent renderTextComponent = Component.literal((String)this.renderText);
        float bounceScale = this.baseScale;
        if (this.bounce) {
            bounceScale -= Mth.abs((float)(Mth.sin((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        }
        bounceScale *= 100.0f / (float)(this.font.width((FormattedText)renderTextComponent) + 32);
        int finalAlpha = Mth.ceil((float)(this.opacity * 255.0f));
        int finalColor = ARGB.color((int)finalAlpha, (int)this.baseColor.getColorInt());
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.getAbsoluteX() + (float)this.getAbsoluteWidth() / 2.0f, (float)this.getAbsoluteY() + (float)this.getAbsoluteHeight() / 2.0f);
        graphics.pose().rotate((float)Math.toRadians(-this.rotation));
        float finalScale = this.scale * bounceScale;
        graphics.pose().scale(finalScale, finalScale);
        int textWidth = this.font.width((FormattedText)renderTextComponent);
        int n = -textWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)renderTextComponent, n, -9 / 2, finalColor, this.shadow);
        graphics.pose().popMatrix();
    }

    protected SplashTextElementBuilder getBuilder() {
        return (SplashTextElementBuilder)this.builder;
    }

    public static enum SourceMode {
        DIRECT_TEXT("direct"),
        TEXT_FILE("text_file"),
        VANILLA("vanilla");

        final String name;

        private SourceMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

