/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.ticker;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.ticker.TickerElementBuilder;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TickerElement
extends AbstractElement
implements ExecutableElement {
    @NotNull
    public volatile GenericExecutableBlock actionExecutor = new GenericExecutableBlock();
    public volatile long tickDelayMs = 0L;
    public volatile boolean isAsync = false;
    public volatile TickMode tickMode = TickMode.NORMAL;
    protected volatile boolean ready = false;
    protected volatile boolean ticked = false;
    protected volatile long lastTick = -1L;
    protected volatile TickerElementThreadController asyncThreadController = null;

    public TickerElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    protected void tickerElementTick() {
        if (this.ready && this.shouldRender()) {
            if (this.ticked && this.tickMode == TickMode.ON_MENU_LOAD) {
                return;
            }
            if (this.tickMode == TickMode.ONCE_PER_SESSION && TickerElementBuilder.cachedOncePerSessionItems.contains(this.getInstanceIdentifier())) {
                return;
            }
            if (this.tickMode == TickMode.ONCE_PER_SESSION) {
                TickerElementBuilder.cachedOncePerSessionItems.add(this.getInstanceIdentifier());
            } else {
                TickerElementBuilder.cachedOncePerSessionItems.remove(this.getInstanceIdentifier());
            }
            long now = System.currentTimeMillis();
            if (this.tickDelayMs <= 0L || this.lastTick + this.tickDelayMs <= now) {
                this.lastTick = now;
                this.ticked = true;
                this.actionExecutor.execute();
            }
        }
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.ready = true;
        if (TickerElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorInt());
            graphics.enableScissor(x, y, x + w, y + h);
            Font font = Minecraft.getInstance().font;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, component, n, n2 - 9 / 2, -1);
            graphics.disableScissor();
        } else if (!this.isAsync) {
            this.tickerElementTick();
        }
        if (!(!this.isAsync || this.asyncThreadController != null && this.asyncThreadController.running || TickerElement.isEditor())) {
            this.asyncThreadController = new TickerElementThreadController();
            TickerElementBuilder.cachedThreadControllers.add(this.asyncThreadController);
            new Thread(() -> {
                while (this.asyncThreadController != null && this.asyncThreadController.running && this.isAsync) {
                    this.tickerElementTick();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        if (!this.isAsync && this.asyncThreadController != null) {
            this.asyncThreadController.running = false;
        }
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.actionExecutor;
    }

    public static enum TickMode {
        NORMAL("normal"),
        ONCE_PER_SESSION("once_per_session"),
        ON_MENU_LOAD("on_menu_load");

        public final String name;

        private TickMode(String name) {
            this.name = name;
        }

        @Nullable
        public static TickMode getByName(String name) {
            for (TickMode t : TickMode.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return null;
        }
    }

    public static class TickerElementThreadController {
        public volatile boolean running = true;
    }
}

