/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.gui;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddyGuiButton
implements Renderable {
    public static final ResourceLocation DEFAULT_BUTTON_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/gui/default_button_normal.png");
    public static final ResourceLocation DEFAULT_BUTTON_HOVER = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/gui/default_button_hover.png");
    public static final ResourceLocation DEFAULT_BUTTON_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/gui/default_button_inactive.png");
    public static final ResourceLocation BUTTON_CLOSE_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/gui/button_close_normal.png");
    public static final ResourceLocation BUTTON_CLOSE_HOVER = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/gui/button_close_hover.png");
    private static final int DEFAULT_BUTTON_WIDTH = 80;
    private static final int DEFAULT_BUTTON_HEIGHT = 20;
    @NotNull
    protected final ButtonNameSupplier nameSupplier;
    @NotNull
    protected final Runnable action;
    @Nullable
    protected final BooleanSupplier activeCondition;
    @NotNull
    protected final Buddy buddy;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean active = true;
    @Nullable
    protected ResourceLocation normalTexture = null;
    @Nullable
    protected ResourceLocation hoverTexture = null;
    @Nullable
    protected ResourceLocation inactiveTexture = null;

    public BuddyGuiButton(@NotNull Buddy buddy, int x, int y, int width, int height, @NotNull ButtonNameSupplier nameSupplier, @NotNull Runnable action, @Nullable BooleanSupplier activeCondition) {
        this.nameSupplier = nameSupplier;
        this.action = action;
        this.activeCondition = activeCondition;
        this.buddy = buddy;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setDefaultButtonTextures();
    }

    public BuddyGuiButton(@NotNull Buddy buddy, int x, int y, @NotNull ButtonNameSupplier nameSupplier, @NotNull Runnable action, @Nullable BooleanSupplier activeCondition) {
        this(buddy, x, y, 80, 20, nameSupplier, action, activeCondition);
    }

    public BuddyGuiButton(@NotNull Buddy buddy, @NotNull ButtonNameSupplier nameSupplier, @NotNull Runnable action, @Nullable BooleanSupplier activeCondition) {
        this(buddy, 0, 0, 80, 20, nameSupplier, action, activeCondition);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        ResourceLocation backgroundTexture;
        boolean hovered;
        boolean bl = hovered = this.isMouseOver(mouseX, mouseY) && this.active;
        ResourceLocation resourceLocation = this.active ? (hovered ? this.hoverTexture : this.normalTexture) : (backgroundTexture = this.inactiveTexture);
        int backgroundColor = this.active ? (hovered ? -7303024 : -10461088) : -12566464;
        int textColor = this.active ? -1 : -5592406;
        Font font = Minecraft.getInstance().font;
        if (backgroundTexture != null) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, backgroundTexture, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, backgroundColor);
            graphics.submitOutline(this.x, this.y, this.width, this.height, -16777216);
        }
        String name = this.nameSupplier.name(this.buddy);
        int textX = this.x + (this.width - font.width(name)) / 2;
        int textY = this.y + (this.height - 8) / 2;
        graphics.drawString(font, name, textX, textY, textColor);
    }

    public void onClick() {
        if (this.active) {
            this.action.run();
        }
    }

    public BuddyGuiButton setTextures(@Nullable ResourceLocation normal, @Nullable ResourceLocation hover, @Nullable ResourceLocation inactive) {
        this.normalTexture = normal;
        this.hoverTexture = hover;
        this.inactiveTexture = inactive;
        return this;
    }

    public BuddyGuiButton setDefaultButtonTextures() {
        return this.setTextures(DEFAULT_BUTTON_NORMAL, DEFAULT_BUTTON_HOVER, DEFAULT_BUTTON_INACTIVE);
    }

    public BuddyGuiButton setCloseButtonTextures() {
        return this.setTextures(BUTTON_CLOSE_NORMAL, BUTTON_CLOSE_HOVER, BUTTON_CLOSE_NORMAL);
    }

    public BuddyGuiButton setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public BuddyGuiButton setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public BuddyGuiButton setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public BuddyGuiButton setY(int y) {
        this.y = y;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public BuddyGuiButton setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public BuddyGuiButton setHeight(int height) {
        this.height = height;
        return this;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public boolean isActive() {
        return this.active;
    }

    public void updateActiveState() {
        this.active = this.activeCondition == null || this.activeCondition.getAsBoolean();
    }

    @FunctionalInterface
    public static interface ButtonNameSupplier {
        public String name(@NotNull Buddy var1);
    }
}

