/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea requirementDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public BuildRequirementScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.translatable((String)"fancymenu.editor.loading_requirement.screens.edit_requirement") : Component.translatable((String)"fancymenu.editor.loading_requirement.screens.add_requirement")));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
    }

    protected void init() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.getValue() : "";
        this.searchBar = new ExtendedEditBox(this, Minecraft.getInstance().font, 21, 66, this.width / 2 - 40 - 2, 18, (Component)Component.empty()){

            @Override
            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                super.renderWidget(graphics, mouseX, mouseY, partial);
                if (this.getValue().isBlank() && !this.isFocused()) {
                    MutableComponent mutableComponent = Component.translatable((String)"fancymenu.requirements.build_requirement.screen.search_requirement");
                    int n = this.getX() + 4;
                    int n2 = this.getY() + this.getHeight() / 2;
                    Objects.requireNonNull(this.font);
                    graphics.drawString(this.font, (Component)mutableComponent, n, n2 - 9 / 2, UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt(), false);
                }
            }
        };
        this.searchBar.setValue(oldSearchValue);
        this.searchBar.setResponder(s -> this.updateRequirementsList());
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.requirementsListScrollArea.setWidth(this.width / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.height - 85 - 25, true);
        this.requirementsListScrollArea.setX(20, true);
        this.requirementsListScrollArea.setY(90, true);
        this.requirementDescriptionScrollArea.setWidth(this.width / 2 - 40, true);
        this.requirementDescriptionScrollArea.setHeight(Math.max(40, this.height / 2 - 50 - 25), true);
        this.requirementDescriptionScrollArea.setX(this.width - 20 - this.requirementDescriptionScrollArea.getWidthWithBorder(), true);
        this.requirementDescriptionScrollArea.setY(65, true);
        int doneButtonX = this.width - 20 - 150;
        int doneButtonY = this.height - 20 - 20;
        int cancelButtonX = doneButtonX;
        int cancelButtonY = doneButtonY - 5 - 20;
        int editValueButtonX = doneButtonX;
        int editValueButtonY = (this.isEdit ? doneButtonY : cancelButtonY) - 15 - 20;
        int requirementModeButtonX = doneButtonX;
        int requirementModeButtonY = editValueButtonY - 5 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (Component)Component.translatable((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value"), button -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement != null && !this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal", new String[0]));
        }).setIsActiveSupplier(consumes -> this.instance.requirement != null && this.instance.requirement.hasValue());
        this.addRenderableWidget((GuiEventListener)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.done"), button -> {
            Minecraft.getInstance().setScreen(this.parentScreen);
            this.callback.accept(this.instance);
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_requirement_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_value_set", new String[0]));
            }
            return null;
        }).setIsActiveSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return false;
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return false;
            }
            return true;
        });
        this.addRenderableWidget((GuiEventListener)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.cancel"), button -> {
            Minecraft.getInstance().setScreen(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        }).setIsActiveSupplier(consumes -> !this.isEdit);
        cancelButton.visible = !this.isEdit;
        this.addRenderableWidget((GuiEventListener)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        ExtendedButton requirementModeButton = new ExtendedButton(requirementModeButtonX, requirementModeButtonY, 150, 20, (Component)Component.empty(), button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.desc", new String[0]))).setLabelSupplier(consumes -> {
            if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                return Component.translatable((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.normal");
            }
            return Component.translatable((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.opposite");
        });
        this.addRenderableWidget((GuiEventListener)requirementModeButton);
        UIBase.applyDefaultWidgetSkinTo(requirementModeButton);
        this.updateRequirementsList();
        this.setDescription(this.instance.requirement);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.title.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        graphics.drawString(this.font, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"fancymenu.editor.loading_requirement.screens.build_screen.available_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementsListScrollArea.render(graphics, mouseX, mouseY, partial);
        MutableComponent descLabel = Component.translatable((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_description");
        int descLabelWidth = this.font.width((FormattedText)descLabel);
        graphics.drawString(this.font, (Component)descLabel, this.width - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.requirementDescriptionScrollArea.clearEntries();
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.requirementDescriptionScrollArea, (Component)Component.literal((String)s).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.requirementDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected boolean requirementFitsSearchValue(@NotNull LoadingRequirement requirement, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (requirement.getDisplayName().toLowerCase().contains(s)) {
            return true;
        }
        return this.requirementDescriptionContains(requirement, s);
    }

    protected boolean requirementDescriptionContains(@NotNull LoadingRequirement requirement, @NotNull String s) {
        List desc = Objects.requireNonNullElse(requirement.getDescription(), new ArrayList());
        for (String line : desc) {
            if (!line.toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block7: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block6: {
                TextListScrollAreaEntry e;
                MutableComponent label;
                String searchValue;
                String string = searchValue = this.searchBar != null ? this.searchBar.getValue() : "";
                if (searchValue.isBlank()) {
                    searchValue = null;
                }
                this.requirementsListScrollArea.clearEntries();
                if (searchValue != null) {
                    for (LoadingRequirement r : LoadingRequirementRegistry.getRequirements()) {
                        if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance()) || !this.requirementFitsSearchValue(r, searchValue)) continue;
                        MutableComponent label2 = Component.literal((String)r.getDisplayName()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                        RequirementScrollEntry e2 = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label2, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                            this.instance.requirement = r;
                            this.setDescription(this.instance.requirement);
                        });
                        e2.requirement = r;
                        this.requirementsListScrollArea.addEntry(e2);
                    }
                    return;
                }
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                if (category != null) break block6;
                for (Map.Entry<String, List<LoadingRequirement>> m : categories.entrySet()) {
                    label = Component.literal((String)m.getKey()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                        this.setContentOfRequirementsList((String)m.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setSelectable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                for (LoadingRequirement r : LoadingRequirementRegistry.getRequirementsWithoutCategory()) {
                    if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    label = Component.literal((String)r.getDisplayName()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    ((RequirementScrollEntry)e).requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block7;
            }
            MutableComponent backLabel = Component.translatable((String)"fancymenu.editor.loading_requirement.screens.lists.back").withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry backEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)backLabel, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            backEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(backEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block7;
            for (LoadingRequirement r : l) {
                if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                MutableComponent label = Component.literal((String)r.getDisplayName()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    protected void updateRequirementsList() {
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public static class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;

        public RequirementScrollEntry(ScrollArea parent, @NotNull Component text, @NotNull Color listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
        }
    }
}

