/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.input.InputConstants;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsKeyPressedRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsKeyPressedRequirement() {
        super("is_key_pressed");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            int keycode = SerializationUtils.deserializeNumber(Integer.class, -1, value);
            InputConstants.Key key = IsKeyPressedRequirement.getKey(keycode);
            return key.getValue() != -1 && InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)key.getValue());
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.requirements.is_key_pressed", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_key_pressed.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.editor.loading_requirement.category.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "-1:-1";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsKeyPressedValueConfigScreen s = new IsKeyPressedValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    @NotNull
    public static InputConstants.Key getKey(int keyCode) {
        KeyEvent event = new KeyEvent(keyCode, -1, -1);
        InputConstants.Key key = null;
        try {
            key = InputConstants.getKey((KeyEvent)event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return key != null ? key : InputConstants.UNKNOWN;
    }

    public static class IsKeyPressedValueConfigScreen
    extends StringBuilderScreen {
        protected int keyCode;
        protected boolean keyInputModeEnabled = false;
        protected CellScreen.LabelCell selectedKeyLabel = null;
        protected CellScreen.LabelCell pressNowLabel = null;

        protected IsKeyPressedValueConfigScreen(String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.requirements.is_key_pressed.screen.title"), callback);
            if (value == null) {
                value = "";
            }
            this.keyCode = SerializationUtils.deserializeNumber(Integer.class, -1, value);
            if (this.keyCode == -1) {
                this.keyCode = 71;
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            InputConstants.Key key = IsKeyPressedRequirement.getKey(this.keyCode);
            this.selectedKeyLabel = this.addLabelCell((Component)Component.translatable((String)"fancymenu.requirements.is_key_pressed.screen.selected_key", (Object[])new Object[]{((MutableComponent)key.getDisplayName()).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt()))}));
            this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 0, 20, (Component)Component.translatable((String)"fancymenu.requirements.is_key_pressed.screen.change_key"), button -> {
                this.keyInputModeEnabled = true;
                this.pressNowLabel.setText((Component)Component.translatable((String)"fancymenu.requirements.is_key_pressed.screen.change_key.press_now").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt())));
                button.setFocused(false);
            }).setIsActiveSupplier(consumes -> !this.keyInputModeEnabled), true);
            this.pressNowLabel = this.addLabelCell((Component)Component.empty());
            this.addSpacerCell(20);
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.keyInputModeEnabled) {
                this.keyCode = event.key();
                this.keyInputModeEnabled = false;
                this.pressNowLabel.setText((Component)Component.empty());
                InputConstants.Key key = IsKeyPressedRequirement.getKey(this.keyCode);
                this.selectedKeyLabel.setText((Component)Component.translatable((String)"fancymenu.requirements.is_key_pressed.screen.selected_key", (Object[])new Object[]{((MutableComponent)key.getDisplayName()).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt()))}));
                return true;
            }
            return super.keyPressed(event);
        }

        @Override
        @NotNull
        public String buildString() {
            return "" + this.keyCode;
        }
    }
}

