/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsMenuTitleRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsMenuTitleRequirement() {
        super("is_menu_title");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        Screen s;
        if (value != null && (s = Minecraft.getInstance().screen) != null) {
            ComponentContents cc;
            String key = null;
            Component title = ScreenTitleUtils.getTitleOfScreen(s);
            if (title instanceof MutableComponent && (cc = title.getContents()) instanceof TranslatableContents) {
                TranslatableContents t = (TranslatableContents)cc;
                key = t.getKey();
            }
            String text = title.getString();
            if (key != null && !I18n.get((String)value, (Object[])new Object[0]).equals(value)) {
                return key.equals(value);
            }
            return text.equals(value);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.editor.loading_requirements.is_menu_title", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirements.is_menu_title.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.editor.loading_requirement.category.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "Example Title";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsMenuTitleValueConfigScreen s = new IsMenuTitleValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public static class IsMenuTitleValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String menuTitleOrKey;
        protected CellScreen.TextInputCell menuTitleOrKeyCell;
        protected EditBoxSuggestions localizationKeySuggestions;

        protected IsMenuTitleValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.menuTitleOrKey = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getMenuTitleOrKeyString();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.loading_requirements.is_menu_title.value"));
            this.menuTitleOrKeyCell = this.addTextInputCell(null, true, true).setText(id);
            this.localizationKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.menuTitleOrKeyCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, LocalizationUtils.getLocalizationKeys());
            UIBase.applyDefaultWidgetSkinTo(this.localizationKeySuggestions);
            this.menuTitleOrKeyCell.editBox.setResponder(s -> this.localizationKeySuggestions.updateCommandInfo());
            this.addSpacerCell(10);
            String key = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            String plain = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            LayoutEditorScreen editor = LayoutEditorScreen.getCurrentInstance();
            if (editor != null && editor.layoutTargetScreen != null) {
                String k = ScreenTitleUtils.getTitleLocalizationKeyOfScreen(editor.layoutTargetScreen);
                if (k != null) {
                    key = k;
                }
                plain = ScreenTitleUtils.getTitleOfScreen(editor.layoutTargetScreen).getString();
            }
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.loading_requirements.is_menu_title.value.current_menu_title_key", (Object[])new Object[]{Component.literal((String)key).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)))}).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.loading_requirements.is_menu_title.value.current_menu_title_plain", (Object[])new Object[]{Component.literal((String)plain).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)))}).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            this.addSpacerCell(20);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.localizationKeySuggestions.render(graphics, mouseX, mouseY);
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.localizationKeySuggestions.keyPressed(event)) {
                return true;
            }
            return super.keyPressed(event);
        }

        public boolean mouseScrolled(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.localizationKeySuggestions.mouseScrolled(scrollDeltaY)) {
                return true;
            }
            return super.mouseScrolled($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.localizationKeySuggestions.mouseClicked(event)) {
                return true;
            }
            return super.mouseClicked(event, isDoubleClick);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getMenuTitleOrKeyString();
        }

        @NotNull
        protected String getMenuTitleOrKeyString() {
            if (this.menuTitleOrKeyCell != null) {
                return this.menuTitleOrKeyCell.getText();
            }
            return this.menuTitleOrKey;
        }
    }
}

