/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Difficulty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsDifficultyRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsDifficultyRequirement() {
        super("is_difficulty");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            ClientLevel level = Minecraft.getInstance().level;
            LocalPlayer player = Minecraft.getInstance().player;
            if (level != null && player != null) {
                return level.getDifficulty().getKey().equals(value);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.requirements.world.is_difficulty", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_difficulty.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.editor.loading_requirement.category.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.get((String)"fancymenu.requirements.world.is_difficulty.value", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "peaceful";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsDifficultyValueConfigScreen s = new IsDifficultyValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    @NotNull
    private static List<String> getDifficultyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (Difficulty d : Difficulty.values()) {
                keys.add(d.getKey());
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get difficulty names for 'Is Difficulty' loading requirement!", (Throwable)ex);
        }
        return keys;
    }

    public static class IsDifficultyValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String value;
        protected CellScreen.TextInputCell textInput;
        protected EditBoxSuggestions suggestions;

        protected IsDifficultyValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.value = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getValueString();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.requirements.world.is_difficulty.value"));
            this.textInput = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            ArrayList<String> suggestionValues = new ArrayList<String>(IsDifficultyRequirement.getDifficultyNames());
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.textInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.textInput.editBox.setResponder(s -> this.suggestions.updateCommandInfo());
            this.addSpacerCell(20);
        }

        @Override
        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.suggestions.render(graphics, mouseX, mouseY);
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.suggestions.keyPressed(event)) {
                return true;
            }
            return super.keyPressed(event);
        }

        public boolean mouseScrolled(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.suggestions.mouseScrolled(scrollDeltaY)) {
                return true;
            }
            return super.mouseScrolled($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.suggestions.mouseClicked(event)) {
                return true;
            }
            return super.mouseClicked(event, isDoubleClick);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getValueString();
        }

        @NotNull
        protected String getValueString() {
            if (this.textInput != null) {
                return this.textInput.getText();
            }
            return this.value;
        }
    }
}

