/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.panorama;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.panorama.PanoramaCubeMapTexture;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.CachedPerspectiveProjectionMatrixBuffer;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTexturePanoramaRenderer
implements Renderable,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public File propertiesFile;
    @NotNull
    public File panoramaImageDir;
    @Nullable
    public File overlayImageFile;
    protected String name = null;
    public final List<ResourceSupplier<ITexture>> panoramaImageSuppliers = new ArrayList<ResourceSupplier<ITexture>>();
    @Nullable
    public ResourceSupplier<ITexture> overlayTextureSupplier;
    protected float speed = 1.0f;
    protected double fov = 85.0;
    protected float angle = 25.0f;
    public float opacity = 1.0f;
    protected volatile boolean tickerThreadRunning = false;
    protected volatile float currentRotation = 0.0f;
    protected volatile long lastRenderCall = -1L;
    @Nullable
    private CubeMap cubeMap = null;
    @Nullable
    private PanoramaCubeMapTexture panoramaCubeMapTexture = null;
    @Nullable
    private ResourceLocation cubeMapLocation = null;
    @Nullable
    private CachedPerspectiveProjectionMatrixBuffer projectionMatrixBuffer = null;
    private final String uniqueId = UUID.randomUUID().toString();

    @Nullable
    public static LocalTexturePanoramaRenderer build(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        LocalTexturePanoramaRenderer renderer = new LocalTexturePanoramaRenderer(propertiesFile, panoramaImageDir, overlayImageFile);
        try {
            if (renderer.propertiesFile.isFile() && renderer.panoramaImageDir.isDirectory()) {
                PropertyContainerSet panoProperties = PropertiesParser.deserializeSetFromFile(renderer.propertiesFile.getAbsolutePath());
                if (panoProperties != null) {
                    PropertyContainer panoMeta = panoProperties.getFirstContainerOfType("panorama-meta");
                    if (panoMeta != null) {
                        String rot;
                        String an;
                        String fo;
                        renderer.name = panoMeta.getValue("name");
                        if (renderer.name == null) {
                            LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'name' value in panorama meta section: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                            return null;
                        }
                        String sp = panoMeta.getValue("speed");
                        if (sp != null && MathUtils.isFloat((String)sp)) {
                            renderer.speed = Float.parseFloat(sp);
                        }
                        if ((fo = panoMeta.getValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                            renderer.fov = Double.parseDouble(fo);
                        }
                        if ((an = panoMeta.getValue("angle")) != null && MathUtils.isFloat((String)an)) {
                            renderer.angle = Float.parseFloat(an);
                        }
                        if ((rot = panoMeta.getValue("start_rotation")) != null && MathUtils.isFloat((String)rot)) {
                            renderer.currentRotation = Float.parseFloat(rot);
                            if (renderer.currentRotation > 360.0f || renderer.currentRotation < 0.0f) {
                                renderer.currentRotation = 0.0f;
                            }
                        }
                        renderer.prepare();
                        renderer.initialize();
                        return renderer;
                    }
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'panorama-meta' section in properties instance: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                } else {
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Parsed properties instance was NULL: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] An error happened while trying to build a cubic panorama!", (Throwable)ex);
        }
        return null;
    }

    protected LocalTexturePanoramaRenderer(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        this.propertiesFile = Objects.requireNonNull(propertiesFile);
        this.panoramaImageDir = Objects.requireNonNull(panoramaImageDir);
        this.overlayImageFile = overlayImageFile;
    }

    protected void prepare() {
        this.panoramaImageSuppliers.clear();
        this.overlayTextureSupplier = null;
        for (int i = 0; i < 6; ++i) {
            File panoImage = new File(this.panoramaImageDir, "panorama_" + i + ".png");
            if (!panoImage.isFile()) {
                LOGGER.error("[FANCYMENU] Unable to load panorama! Missing panorama image 'panorama_" + i + ".png': " + this.name);
                return;
            }
            this.panoramaImageSuppliers.add(ResourceSupplier.image(ResourceSource.of(panoImage.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix()));
        }
        if (this.overlayImageFile != null && this.overlayImageFile.isFile()) {
            this.overlayTextureSupplier = ResourceSupplier.image(ResourceSource.of(this.overlayImageFile.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix());
        }
    }

    protected void initialize() {
        this.panoramaCubeMapTexture = new PanoramaCubeMapTexture(this.name != null ? this.name : "unnamed", this.panoramaImageSuppliers);
        this.cubeMapLocation = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)("panorama_" + this.uniqueId));
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        textureManager.register(this.cubeMapLocation, (AbstractTexture)this.panoramaCubeMapTexture);
        this.cubeMap = new CubeMap(this.cubeMapLocation);
        this.projectionMatrixBuffer = new CachedPerspectiveProjectionMatrixBuffer("fancymenu_panorama_" + this.uniqueId, 0.05f, 10.0f);
    }

    protected void startTickerThreadIfNeeded() {
        if (this.tickerThreadRunning) {
            return;
        }
        this.lastRenderCall = System.currentTimeMillis();
        this.tickerThreadRunning = true;
        new Thread(() -> {
            while (this.lastRenderCall + 5000L > System.currentTimeMillis()) {
                try {
                    this.currentRotation += 0.03f;
                    if (this.currentRotation >= 360.0f) {
                        this.currentRotation = 0.0f;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
                try {
                    Thread.sleep(Math.max(2, (int)(20.0f / this.speed)));
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
            }
            this.tickerThreadRunning = false;
        }, "FancyMenu Panorama Ticker Thread").start();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.lastRenderCall = System.currentTimeMillis();
        this.startTickerThreadIfNeeded();
        if (this.panoramaCubeMapTexture == null || this.panoramaCubeMapTexture.isLoadFailed()) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, ITexture.MISSING_TEXTURE_LOCATION, 0, 0, 0.0f, 0.0f, ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight(), ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight());
            return;
        }
        if (!this.panoramaCubeMapTexture.isLoaded()) {
            this.panoramaCubeMapTexture.getTextureView();
            return;
        }
        this._render(graphics, Minecraft.getInstance(), this.opacity);
    }

    private void _render(@NotNull GuiGraphics graphics, Minecraft mc, float alpha) {
        ResourceLocation location;
        ITexture texture;
        int screenW = ScreenUtils.getScreenWidth();
        int screenH = ScreenUtils.getScreenHeight();
        float pitch = this.angle;
        float yaw = -this.currentRotation;
        this.renderCubeMapWithAlpha(mc, pitch, yaw, alpha);
        if (this.overlayTextureSupplier != null && (texture = this.overlayTextureSupplier.get()) != null && (location = texture.getResourceLocation()) != null) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, location, 0, 0, 0.0f, 0.0f, screenW, screenH, screenW, screenH, ARGB.white((float)this.opacity));
        }
    }

    private void renderCubeMapWithAlpha(Minecraft mc, float pitch, float yaw, float alpha) {
        if (this.cubeMap != null && this.projectionMatrixBuffer != null) {
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer(mc.getWindow().getWidth(), mc.getWindow().getHeight(), (float)this.fov), (ProjectionType)ProjectionType.PERSPECTIVE);
            this.cubeMap.render(mc, pitch, yaw);
            RenderSystem.restoreProjectionMatrix();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public void close() {
        if (this.cubeMap != null) {
            this.cubeMap.close();
            this.cubeMap = null;
        }
        if (this.panoramaCubeMapTexture != null) {
            this.panoramaCubeMapTexture.close();
            this.panoramaCubeMapTexture = null;
        }
        if (this.projectionMatrixBuffer != null) {
            this.projectionMatrixBuffer.close();
            this.projectionMatrixBuffer = null;
        }
        if (this.cubeMapLocation != null) {
            Minecraft.getInstance().getTextureManager().release(this.cubeMapLocation);
            this.cubeMapLocation = null;
        }
    }
}

