/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtDataGetPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public NbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return "";
        }
        if (sourceType == null || nbtPath == null) {
            return "";
        }
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }
        try {
            NbtPathArgument.NbtPath path = NbtPathArgument.NbtPath.of((String)nbtPath);
            CompoundTag sourceData = this.getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }
            List tags = path.get((Tag)sourceData);
            if (tags.isEmpty()) {
                return "";
            }
            Tag tag = (Tag)tags.get(0);
            if ("string".equalsIgnoreCase(returnType)) {
                return this.getTagAsString(tag);
            }
            if ("snbt".equalsIgnoreCase(returnType)) {
                return tag.toString();
            }
            if ("json".equalsIgnoreCase(returnType) && tag instanceof CompoundTag) {
                Component component = NbtUtils.toPrettyComponent((Tag)tag);
                String json = ((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)component).getOrThrow()).toString();
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = json.substring(1, json.length() - 1);
                }
                return json;
            }
            double scale = 1.0;
            if (scaleStr != null && !scaleStr.isEmpty()) {
                try {
                    scale = Double.parseDouble(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getTagValue(tag, scale);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder: " + e.getMessage());
            return "";
        }
    }

    private CompoundTag getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        switch (sourceType.toLowerCase()) {
            case "entity": {
                return this.getEntityData(dps);
            }
            case "block": {
                return this.getBlockData(dps);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompoundTag getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null) {
            return null;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return null;
        }
        LocalPlayer targetEntity = null;
        block6 : switch (selector) {
            case "@s": 
            case "@p": {
                targetEntity = player;
                break;
            }
            case "@e": {
                double nearestDist = Double.MAX_VALUE;
                for (Entity entity : level.entitiesForRendering()) {
                    double dist = entity.distanceToSqr((Entity)player);
                    if (!(dist < nearestDist)) continue;
                    nearestDist = dist;
                    targetEntity = entity;
                }
                break;
            }
            default: {
                try {
                    UUID uuid = UUID.fromString(selector);
                    for (Entity entity : level.entitiesForRendering()) {
                        if (!entity.getUUID().equals(uuid)) continue;
                        targetEntity = entity;
                    }
                    break;
                }
                catch (IllegalArgumentException e) {
                    for (Entity entity : level.entitiesForRendering()) {
                        if (!entity.getName().getString().equals(selector)) continue;
                        targetEntity = entity;
                        break block6;
                    }
                }
            }
        }
        if (targetEntity == null) {
            return null;
        }
        TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        targetEntity.saveWithoutId((ValueOutput)valueOutput);
        return valueOutput.buildResult();
    }

    private CompoundTag getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null) {
            return null;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        try {
            int z;
            int y;
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0]);
            BlockPos pos = new BlockPos(x, y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2]));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                return blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("[FANCYMENU] Invalid block position: " + posStr);
        }
        return null;
    }

    private String getTagAsString(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return stringTag.value();
        }
        if (tag instanceof NumericTag) {
            return tag.toString();
        }
        return tag.toString();
    }

    private String getTagValue(Tag tag, double scale) {
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            if (scale != 1.0) {
                return String.valueOf(Mth.floor((double)(numericTag.doubleValue() * scale)));
            }
            return String.valueOf(Mth.floor((double)numericTag.doubleValue()));
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return String.valueOf(stringTag.value().length());
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            return String.valueOf(collectionTag.size());
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return String.valueOf(compoundTag.size());
        }
        return this.getTagAsString(tag);
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.nbt_data_get", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

