/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.client;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinLevelLoadingScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinProgressScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldLoadProgressPlaceholder
extends Placeholder {
    public WorldLoadProgressPlaceholder() {
        super("world_load_progress");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        Screen s = Minecraft.getInstance().screen;
        if (s instanceof ProgressScreen) {
            ProgressScreen p = (ProgressScreen)s;
            return "" + ((IMixinProgressScreen)p).getProgressFancyMenu();
        }
        if (s instanceof LevelLoadingScreen) {
            LevelLoadingScreen l = (LevelLoadingScreen)s;
            return "" + (int)(((IMixinLevelLoadingScreen)l).get_loadTracker_FancyMenu().serverProgress() * 100.0f);
        }
        return "0";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.world_load_progress", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world_load_progress.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.client", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        return dps;
    }
}

