/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinBossHealthOverlay;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.component.ComponentSerialization;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossNamePlaceholder
extends Placeholder {
    public BossNamePlaceholder() {
        super("boss_name");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        Map<UUID, LerpingBossEvent> bosses;
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        int index = SerializationUtils.deserializeNumber(Integer.class, 0, dps.values.get("boss_index"));
        boolean asJson = SerializationUtils.deserializeBoolean(false, dps.values.get("as_json"));
        if (player != null && level != null && (bosses = ((IMixinBossHealthOverlay)Minecraft.getInstance().gui.getBossOverlay()).get_events_FancyMenu()).size() >= index + 1) {
            int i = 0;
            for (Map.Entry<UUID, LerpingBossEvent> m : bosses.entrySet()) {
                if (index == i) {
                    if (asJson) {
                        return ComponentSerialization.Serializer.toJson(m.getValue().getName(), (HolderLookup.Provider)level.registryAccess());
                    }
                    return TextFormattingUtils.textComponentToString(m.getValue().getName());
                }
                ++i;
            }
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("boss_index", "as_json");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.world.boss_name", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.boss_name.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("boss_index", "0");
        values.put("as_json", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

