/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.screen;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.screen.ExecuteOnRenderScreen;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenInstanceFactory {
    private static final Map<Class<?>, Object> DEFAULT_PARAMETERS = new HashMap();
    private static final Map<String, Supplier<? extends Screen>> SCREEN_INSTANCE_PROVIDERS = new HashMap<String, Supplier<? extends Screen>>();

    public static void registerScreenProvider(@NotNull String screenClassPath, @NotNull Supplier<? extends Screen> provider) {
        SCREEN_INSTANCE_PROVIDERS.put(screenClassPath, provider);
    }

    @Nullable
    public static Supplier<? extends Screen> getScreenProvider(@NotNull String screenClassPath) {
        return SCREEN_INSTANCE_PROVIDERS.get(screenClassPath);
    }

    @Nullable
    public static Screen tryConstruct(@NotNull String screenClassPathOrIdentifier) {
        try {
            Constructor<?>[] constructors;
            Supplier<? extends Screen> screenProvider;
            String nonUniversal;
            if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenClassPathOrIdentifier) && (nonUniversal = UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenClassPathOrIdentifier)) != null) {
                screenClassPathOrIdentifier = nonUniversal;
            }
            if (ScreenCustomization.isScreenBlacklisted(screenClassPathOrIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenClassPathOrIdentifier))) {
                return null;
            }
            DEFAULT_PARAMETERS.put(Screen.class, Minecraft.getInstance().screen);
            DEFAULT_PARAMETERS.put(Player.class, Minecraft.getInstance().player);
            if (Minecraft.getInstance().player != null) {
                DEFAULT_PARAMETERS.put(ClientAdvancements.class, Minecraft.getInstance().player.connection.getAdvancements());
            }
            if ((screenProvider = ScreenInstanceFactory.getScreenProvider(screenClassPathOrIdentifier)) != null) {
                return screenProvider.get();
            }
            Class<?> screenClass = Class.forName(screenClassPathOrIdentifier, false, ScreenInstanceFactory.class.getClassLoader());
            if (Screen.class.isAssignableFrom(screenClass) && (constructors = screenClass.getConstructors()).length > 0) {
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 0) continue;
                    constructor = c;
                    break;
                }
                if (constructor == null) {
                    for (Constructor<?> c : constructors) {
                        if (!ScreenInstanceFactory.allParametersSupported(c.getParameterTypes())) continue;
                        constructor = c;
                        break;
                    }
                }
                if (constructor != null) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    ArrayList<Object> parameterInstances = new ArrayList<Object>();
                    for (Class<?> p : parameters) {
                        parameterInstances.add(DEFAULT_PARAMETERS.get(p));
                    }
                    return ScreenInstanceFactory.createInstance(constructor, parameterInstances);
                }
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static boolean allParametersSupported(Class<?>[] parameters) {
        for (Class<?> par : parameters) {
            if (DEFAULT_PARAMETERS.containsKey(par)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Screen createInstance(@NotNull Constructor<?> constructor, @Nullable List<Object> parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return (Screen)constructor.newInstance(new Object[0]);
            }
            return (Screen)constructor.newInstance(parameters.toArray(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        DEFAULT_PARAMETERS.put(Minecraft.class, Minecraft.getInstance());
        DEFAULT_PARAMETERS.put(Screen.class, null);
        DEFAULT_PARAMETERS.put(Options.class, Minecraft.getInstance().options);
        DEFAULT_PARAMETERS.put(LanguageManager.class, Minecraft.getInstance().getLanguageManager());
        DEFAULT_PARAMETERS.put(Player.class, null);
        DEFAULT_PARAMETERS.put(String.class, "");
        DEFAULT_PARAMETERS.put(ClientAdvancements.class, null);
        DEFAULT_PARAMETERS.put(Component.class, Component.empty());
        DEFAULT_PARAMETERS.put(Boolean.TYPE, true);
        DEFAULT_PARAMETERS.put(Integer.TYPE, 0);
        DEFAULT_PARAMETERS.put(Long.TYPE, 0L);
        DEFAULT_PARAMETERS.put(Double.TYPE, 0.0);
        DEFAULT_PARAMETERS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_PARAMETERS.put(Boolean.class, true);
        DEFAULT_PARAMETERS.put(Integer.class, 0);
        DEFAULT_PARAMETERS.put(Long.class, 0L);
        DEFAULT_PARAMETERS.put(Double.class, 0.0);
        DEFAULT_PARAMETERS.put(Float.class, Float.valueOf(0.0f));
        ScreenInstanceFactory.registerScreenProvider(PackSelectionScreen.class.getName(), () -> new PackSelectionScreen(Minecraft.getInstance().getResourcePackRepository(), repo -> {
            Minecraft.getInstance().options.updateResourcePacks(repo);
            Minecraft.getInstance().setScreen(Minecraft.getInstance().screen);
        }, Minecraft.getInstance().getResourcePackDirectory(), (Component)Component.translatable((String)"resourcePack.title")));
        ScreenInstanceFactory.registerScreenProvider(CreateWorldScreen.class.getName(), () -> new ExecuteOnRenderScreen(() -> CreateWorldScreen.openFresh((Minecraft)Minecraft.getInstance(), () -> Minecraft.getInstance().setScreen((Screen)new TitleScreen())), true));
    }
}

