/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.platform.services;

import com.mojang.blaze3d.platform.InputConstants;
import de.keksuccino.fancymenu.util.mod.UniversalModContainer;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPlatformHelper {
    public String getPlatformName();

    public String getPlatformDisplayName();

    public String getLoaderVersion();

    public boolean isModLoaded(String var1);

    public String getModVersion(String var1);

    public List<String> getLoadedModIds();

    public boolean isDevelopmentEnvironment();

    public boolean isOnClient();

    public InputConstants.Key getKeyMappingKey(KeyMapping var1);

    @Nullable
    public ResourceLocation getItemKey(@NotNull Item var1);

    @Nullable
    public ResourceLocation getEffectKey(@NotNull MobEffect var1);

    @Nullable
    public ResourceLocation getEntityKey(@NotNull EntityType<?> var1);

    @NotNull
    public List<UniversalModContainer> getLoadedMods();

    @Nullable
    default public UniversalModContainer getLoadedMod(@NotNull String id) {
        for (UniversalModContainer mod : this.getLoadedMods()) {
            if (!id.equals(mod.id())) continue;
            return mod;
        }
        return null;
    }

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }
}

