/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import org.joml.Matrix3x2f;

public record FloatColoredRectangleRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f transform, float minX, float minY, float maxX, float maxY, int startColor, int endColor, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
{
    public FloatColoredRectangleRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f transform, float minX, float minY, float maxX, float maxY, int startColor, int endColor, @Nullable ScreenRectangle scissorRectangle) {
        this(pipeline, textureSetup, transform, minX, minY, maxX, maxY, startColor, endColor, scissorRectangle, FloatColoredRectangleRenderState.getBounds(minX, minY, maxX, maxY, transform, scissorRectangle));
    }

    public void buildVertices(VertexConsumer vertexConsumer) {
        vertexConsumer.addVertexWith2DPose(this.transform(), this.minX(), this.minY()).setColor(this.startColor());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.minX(), this.maxY()).setColor(this.endColor());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.maxX(), this.maxY()).setColor(this.endColor());
        vertexConsumer.addVertexWith2DPose(this.transform(), this.maxX(), this.minY()).setColor(this.startColor());
    }

    @Nullable
    private static ScreenRectangle getBounds(float minX, float minY, float maxX, float maxY, Matrix3x2f transform, @Nullable ScreenRectangle scissorRectangle) {
        int x = (int)minX;
        int y = (int)minY;
        int width = (int)(maxX - minX);
        int height = (int)(maxY - minY);
        ScreenRectangle elementBounds = new ScreenRectangle(x, y, width, height).transformMaxBounds(transform);
        return scissorRectangle != null ? scissorRectangle.intersection(elementBounds) : elementBounds;
    }
}

