/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui;

import de.keksuccino.fancymenu.util.VanillaEvents;
import de.keksuccino.fancymenu.util.rendering.ui.FocuslessContainerEventHandler;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.NotNull;

public abstract class UIComponent
extends UIBase
implements FocuslessContainerEventHandler,
Renderable,
NarratableEntry {
    public float posZ = 0.0f;
    protected boolean hovered = false;
    protected boolean visible = true;
    protected Minecraft mc = Minecraft.getInstance();
    protected boolean dragging = false;
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public abstract void renderComponent(@NotNull GuiGraphics var1, double var2, double var4, float var6);

    public void render(@NotNull GuiGraphics graphics, int ignoredMouseX, int ignoredMouseY, float partial) {
        if (!this.isVisible()) {
            return;
        }
        this.hovered = this.isMouseOver();
        graphics.pose().pushMatrix();
        graphics.pose().scale(this.getFixedComponentScale(), this.getFixedComponentScale());
        graphics.pose().translate(this.getTranslatedX(), this.getTranslatedY());
        this.renderComponent(graphics, this.getRealMouseX(), this.getRealMouseY(), partial);
        graphics.pose().popMatrix();
    }

    protected float getRealX() {
        return 0.0f;
    }

    protected float getRealY() {
        return 0.0f;
    }

    public abstract float getTranslatedX();

    public abstract float getTranslatedY();

    public abstract float getWidth();

    public abstract float getHeight();

    public double getRealMouseX() {
        return (this.mc.mouseHandler.xpos() - (double)(this.getTranslatedX() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getRealMouseY() {
        return (this.mc.mouseHandler.ypos() - (double)(this.getTranslatedY() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getTranslatedMouseX() {
        return this.mc.mouseHandler.xpos() / (double)this.getComponentScale();
    }

    public double getTranslatedMouseY() {
        return this.mc.mouseHandler.ypos() / (double)this.getComponentScale();
    }

    protected float getScreenWidth() {
        return (float)this.mc.getWindow().getWidth() / this.getComponentScale();
    }

    protected float getScreenHeight() {
        return (float)this.mc.getWindow().getHeight() / this.getComponentScale();
    }

    protected boolean isComponentAreaHovered(float x, float y, float width, float height, boolean isRealPosition) {
        double mX = this.getRealMouseX();
        double mY = this.getRealMouseY();
        if (!isRealPosition) {
            x -= this.getTranslatedX();
            y -= this.getTranslatedY();
        }
        return UIComponent.isXYInArea(mX, mY, x, y, width + 1.0f, height + 1.0f);
    }

    public float getComponentScale() {
        return UIComponent.getUIScale();
    }

    public float getFixedComponentScale() {
        return UIComponent.calculateFixedScale(this.getComponentScale());
    }

    protected void enableComponentScissor(GuiGraphics graphics, int x, int y, int width, int height, boolean isRealPosition) {
        if (isRealPosition) {
            x = (int)((float)x + this.getTranslatedX());
            y = (int)((float)y + this.getTranslatedY());
        }
        int scissorX = (int)((float)x * this.getFixedComponentScale());
        int scissorY = (int)((float)y * this.getFixedComponentScale());
        int scissorWidth = (int)((float)width * this.getFixedComponentScale());
        int scissorHeight = (int)((float)height * this.getFixedComponentScale());
        graphics.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
    }

    protected void disableComponentScissor(GuiGraphics graphics) {
        graphics.disableScissor();
    }

    public boolean isHovered() {
        if (!this.isVisible()) {
            return false;
        }
        return this.hovered;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @NotNull
    public List<GuiEventListener> children() {
        return this.children;
    }

    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.mouseClicked(UIComponent.buildMouseButtonEvent(realMouseX, realMouseY, button), false)) continue;
            this.setFocused(child);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        return this.mouseClickedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.button());
    }

    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        this.setDragging(false);
        for (GuiEventListener child : this.children()) {
            if (!child.mouseReleased(UIComponent.buildMouseButtonEvent(realMouseX, realMouseY, button))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean mouseReleased(MouseButtonEvent event) {
        return this.mouseReleasedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.button());
    }

    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (this.isDragging() && button == 0) {
            for (GuiEventListener child : this.children()) {
                if (!child.mouseDragged(UIComponent.buildMouseButtonEvent(this.getRealMouseX(), this.getRealMouseY(), button), d1, d2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean mouseDragged(MouseButtonEvent event, double d1, double d2) {
        return this.mouseDraggedComponent(this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.button(), d1, d2);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDeltaX, double scrollDeltaY) {
        for (GuiEventListener child : this.children()) {
            if (!child.mouseScrolled(realMouseX, realMouseY, scrollDeltaX, scrollDeltaY)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean mouseScrolled(double ignoredMouseX, double ignoredMouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.mouseScrolledComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), scrollDeltaX, scrollDeltaY);
    }

    protected void mouseMovedComponent(double realMouseX, double realMouseY) {
    }

    @Deprecated
    public void mouseMoved(double ignoredMouseX, double ignoredMouseY) {
        this.mouseMovedComponent(this.getRealMouseX(), this.getRealMouseY());
    }

    public boolean isMouseOver() {
        if (!this.isVisible()) {
            return false;
        }
        return this.isComponentAreaHovered(this.getTranslatedX(), this.getTranslatedY(), this.getWidth(), this.getHeight(), false);
    }

    @Deprecated
    public boolean isMouseOver(double ignoredMouseX, double ignoredMouseY) {
        return this.isMouseOver();
    }

    @Override
    public void setFocused(boolean var1) {
    }

    public boolean isFocused() {
        return false;
    }

    @NotNull
    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(@NotNull NarrationElementOutput var1) {
    }

    @NotNull
    public static MouseButtonEvent buildMouseButtonEvent(double mouseX, double mouseY, int button) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, button);
    }
}

