/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;

public class MinecraftLogoRenderer {
    public static final MinecraftLogoRenderer DEFAULT_INSTANCE = new MinecraftLogoRenderer(false);
    public static final ResourceLocation MINECRAFT_LOGO = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/minecraft.png");
    public static final ResourceLocation EASTER_EGG_LOGO = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/minceraft.png");
    public static final ResourceLocation MINECRAFT_EDITION = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/edition.png");
    public static final int LOGO_WIDTH = 256;
    public static final int LOGO_HEIGHT = 44;
    private static final int LOGO_TEXTURE_WIDTH = 256;
    private static final int LOGO_TEXTURE_HEIGHT = 64;
    private static final int EDITION_WIDTH = 128;
    private static final int EDITION_HEIGHT = 14;
    private static final int EDITION_TEXTURE_WIDTH = 128;
    private static final int EDITION_TEXTURE_HEIGHT = 16;
    public static final int DEFAULT_HEIGHT_OFFSET = 30;
    private static final int EDITION_LOGO_OVERLAP = 7;
    private final boolean showEasterEgg = (double)RandomSource.create().nextFloat() < 1.0E-4;
    private final boolean keepLogoThroughFade;

    public MinecraftLogoRenderer(boolean keepLogoThroughFade) {
        this.keepLogoThroughFade = keepLogoThroughFade;
    }

    public int getWidth() {
        return 256;
    }

    public int getHeight() {
        return 51;
    }

    public void renderLogo(GuiGraphics guiGraphics, int screenWidth, float transparency) {
        this.renderLogo(guiGraphics, screenWidth, transparency, 30);
    }

    public void renderLogo(GuiGraphics guiGraphics, int screenWidth, float transparency, int height) {
        int i = screenWidth / 2 - 128;
        float f = this.keepLogoThroughFade ? 1.0f : transparency;
        int j = ARGB.white((float)f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.showEasterEgg ? EASTER_EGG_LOGO : MINECRAFT_LOGO, i, height, 0.0f, 0.0f, 256, 44, 256, 64, j);
        int k = screenWidth / 2 - 64;
        int l = height + 44 - 7;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, MINECRAFT_EDITION, k, l, 0.0f, 0.0f, 128, 14, 128, 16, j);
    }

    public void renderLogoAtPosition(GuiGraphics guiGraphics, int x, int y, float transparency) {
        float f = this.keepLogoThroughFade ? 1.0f : transparency;
        int color = ARGB.white((float)f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.showEasterEgg ? EASTER_EGG_LOGO : MINECRAFT_LOGO, x, y, 0.0f, 0.0f, 256, 44, 256, 64, color);
        int editionX = x + 64;
        int editionY = y + 44 - 7;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, MINECRAFT_EDITION, editionX, editionY, 0.0f, 0.0f, 128, 14, 128, 16, color);
    }
}

