/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSplashRenderer;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.util.Mth;

public class MinecraftSplashRenderer {
    public static final MinecraftSplashRenderer DEFAULT_INSTANCE = new MinecraftSplashRenderer(((IMixinSplashRenderer)Objects.requireNonNullElse(Minecraft.getInstance().getSplashManager().getSplash(), new SplashRenderer("ERROR"))).getSplashFancyMenu());
    public static final int WIDTH_OFFSET = 123;
    public static final int HEIGHT_OFFSET = 69;
    private final String splash;

    public MinecraftSplashRenderer(String splash) {
        this.splash = splash;
    }

    public int getDefaultPositionX(int screenWidth) {
        return screenWidth / 2 + 123;
    }

    public int getDefaultPositionY() {
        return 69;
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, Font font, int color) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)screenWidth / 2.0f + 123.0f, 69.0f);
        guiGraphics.pose().rotate((float)Math.toRadians(-20.0));
        float f = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.width(this.splash) + 32);
        guiGraphics.pose().scale(f, f);
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 0xFFFF00 | color);
        guiGraphics.pose().popMatrix();
    }

    public void renderAt(GuiGraphics guiGraphics, int x, int y, Font font, int color) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y);
        guiGraphics.pose().rotate((float)Math.toRadians(-20.0));
        float f = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.width(this.splash) + 32);
        guiGraphics.pose().scale(f, f);
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 0xFFFF00 | color);
        guiGraphics.pose().popMatrix();
    }

    public String getSplash() {
        return this.splash;
    }
}

