/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.component;

import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWidget
extends AbstractWidget
implements NavigatableWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected ConsumingSupplier<ComponentWidget, MutableComponent> textSupplier;
    protected boolean shadow = true;
    @NotNull
    protected ConsumingSupplier<ComponentWidget, DrawableColor> baseColorSupplier = var -> UIBase.getUIColorTheme().generic_text_base_color;
    protected Consumer<ComponentWidget> onHoverOrFocusStart;
    protected Consumer<ComponentWidget> onHoverOrFocusEnd;
    protected Consumer<ComponentWidget> onClick;
    @Nullable
    protected ComponentWidget parent;
    protected List<ComponentWidget> children = new ArrayList<ComponentWidget>();
    @NotNull
    protected Font font;
    protected boolean isCurrentlyHoveredOrFocused = false;
    protected int endX;

    public static ComponentWidget of(@NotNull MutableComponent component, int x, int y) {
        return new ComponentWidget(Minecraft.getInstance().font, x, y, component);
    }

    public static ComponentWidget literal(@NotNull String text, int x, int y) {
        ComponentWidget w = new ComponentWidget(Minecraft.getInstance().font, x, y, Component.literal((String)""));
        w.setTextSupplier(consumes -> Component.literal((String)PlaceholderParser.replacePlaceholders(text)));
        return w;
    }

    public static ComponentWidget translatable(@NotNull String key, int x, int y) {
        ComponentWidget w = new ComponentWidget(Minecraft.getInstance().font, x, y, Component.literal((String)""));
        w.setTextSupplier(consumes -> Component.translatable((String)key));
        return w;
    }

    public static ComponentWidget empty(int x, int y) {
        return new ComponentWidget(Minecraft.getInstance().font, x, y, Component.literal((String)""));
    }

    protected ComponentWidget(@NotNull Font font, int x, int y, @NotNull MutableComponent text) {
        super(x, y, 0, 0, (Component)text);
        this.textSupplier = var -> text;
        this.font = font;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.handleComponentHover();
        MutableComponent text = this.getText();
        this.endX = this.getX() + this.font.width((FormattedText)text);
        graphics.drawString(this.font, (Component)text, this.getX(), this.getY(), this.getBaseColor().getColorInt(), this.shadow);
        for (ComponentWidget c : this.children) {
            c.setX(this.endX);
            c.setY(this.getY());
            c.render(graphics, mouseX, mouseY, partial);
            this.endX = c.endX;
        }
    }

    public ComponentWidget append(@NotNull ComponentWidget child) {
        child.parent = this;
        this.children.add(child);
        return this;
    }

    public List<ComponentWidget> getChildren() {
        return this.children;
    }

    @Nullable
    public ComponentWidget getParent() {
        return this.parent;
    }

    @NotNull
    public ConsumingSupplier<ComponentWidget, MutableComponent> getTextSupplier() {
        return this.textSupplier;
    }

    public ComponentWidget setTextSupplier(@NotNull ConsumingSupplier<ComponentWidget, MutableComponent> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    @NotNull
    public MutableComponent getText() {
        MutableComponent c = this.textSupplier.get(this);
        if (c == null) {
            c = Component.literal((String)"");
        }
        return c;
    }

    public ComponentWidget setText(@NotNull MutableComponent text) {
        this.textSupplier = var -> text;
        return this;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public ComponentWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        for (ComponentWidget w : this.children) {
            w.shadow = shadow;
        }
        return this;
    }

    public ComponentWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColorSupplier = var -> baseColor;
        for (ComponentWidget w : this.children) {
            w.baseColorSupplier = this.baseColorSupplier;
        }
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        DrawableColor c = this.baseColorSupplier.get(this);
        if (c == null) {
            c = DrawableColor.WHITE;
        }
        return c;
    }

    public ComponentWidget setBaseColorSupplier(@NotNull ConsumingSupplier<ComponentWidget, DrawableColor> baseColorSupplier) {
        this.baseColorSupplier = baseColorSupplier;
        for (ComponentWidget w : this.children) {
            w.baseColorSupplier = baseColorSupplier;
        }
        return this;
    }

    @NotNull
    public ConsumingSupplier<ComponentWidget, DrawableColor> getBaseColorSupplier() {
        return this.baseColorSupplier;
    }

    public ComponentWidget setOnHoverOrFocusStart(@Nullable Consumer<ComponentWidget> onHoverOrFocusStart) {
        this.onHoverOrFocusStart = onHoverOrFocusStart;
        return this;
    }

    public ComponentWidget setOnHoverOrFocusEnd(@Nullable Consumer<ComponentWidget> onHoverOrFocusEnd) {
        this.onHoverOrFocusEnd = onHoverOrFocusEnd;
        return this;
    }

    public ComponentWidget setOnClick(@Nullable Consumer<ComponentWidget> onClick) {
        this.onClick = onClick;
        return this;
    }

    public int getWidth() {
        int w = this.font.width((FormattedText)this.getText());
        for (ComponentWidget c : this.children) {
            w += c.getWidth();
        }
        return w;
    }

    public int getHeight() {
        Objects.requireNonNull(this.font);
        return 9;
    }

    protected void handleComponentHover() {
        if (!this.isCurrentlyHoveredOrFocused) {
            if (this.isHoveredOrFocused()) {
                if (this.onHoverOrFocusStart != null) {
                    this.onHoverOrFocusStart.accept(this);
                }
                this.isCurrentlyHoveredOrFocused = true;
            }
        } else if (!this.isHoveredOrFocused()) {
            if (this.onHoverOrFocusEnd != null) {
                this.onHoverOrFocusEnd.accept(this);
            }
            this.isCurrentlyHoveredOrFocused = false;
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.active && this.visible && this.isHoveredOrFocused() && event.button() == 0) {
            for (ComponentWidget w : this.children) {
                if (!w.mouseClicked(event, isDoubleClick)) continue;
                return true;
            }
            if (this.onClick != null) {
                this.onClick.accept(this);
                return true;
            }
        }
        return false;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput var1) {
    }

    @Deprecated
    public void setMessage(@NotNull Component content) {
        if (content instanceof MutableComponent) {
            MutableComponent m = (MutableComponent)content;
            this.textSupplier = var -> m;
        }
    }

    @Deprecated
    @NotNull
    public Component getMessage() {
        return this.getText();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("ComponentWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("ComponentWidgets are not navigatable!");
    }
}

