/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenScreenAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastErrorTriggered = -1L;

    public OpenScreenAction() {
        super("opengui");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            if (RenderSystem.m_69586_()) {
                if ((value = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(value)).equals(CreateWorldScreen.class.getName())) {
                    CreateWorldScreen.m_232896_((Minecraft)Minecraft.m_91087_(), (Screen)Minecraft.m_91087_().f_91080_);
                } else if (CustomGuiHandler.guiExists(value)) {
                    CustomGuiBaseScreen custom = CustomGuiHandler.constructInstance(value, Minecraft.m_91087_().f_91080_, null);
                    if (custom != null) {
                        Minecraft.m_91087_().m_91152_((Screen)custom);
                    }
                } else {
                    Screen s = ScreenInstanceFactory.tryConstruct(value);
                    if (s != null) {
                        Minecraft.m_91087_().m_91152_(s);
                    } else {
                        LOGGER.error("[FANCYMENU] Unable to construct screen instance for '" + value + "'!", (Throwable)new Exception());
                        Screen current = Minecraft.m_91087_().f_91080_;
                        Minecraft.m_91087_().m_91152_((Screen)NotificationScreen.error(aBoolean -> Minecraft.m_91087_().m_91152_(current), LocalizationUtils.splitLocalizedLines("fancymenu.actions.open_screen.error", new String[0])));
                    }
                }
            } else {
                long now = System.currentTimeMillis();
                if (lastErrorTriggered + 60000L < now) {
                    lastErrorTriggered = now;
                    MainThreadTaskExecutor.executeInMainThread(() -> Minecraft.m_91087_().m_91152_((Screen)new GenericDirtMessageScreen((Component)Component.m_237110_((String)"fancymenu.actions.generic.async_error", (Object[])new Object[]{this.getActionDisplayName()}))), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.opengui");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.opengui.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.opengui.desc.value");
    }

    @Override
    public String getValueExample() {
        return "example.menu.identifier";
    }
}

