/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class ManageOverriddenGuisScreen
extends CellScreen {
    protected Runnable onCloseRunnable;
    protected List<String> removedOverrides = new ArrayList<String>();

    public ManageOverriddenGuisScreen(@NotNull Runnable onClose) {
        super((Component)Components.translatable("fancymenu.custom_guis.manage_overridden", new Object[0]));
        this.onCloseRunnable = onClose;
    }

    @Override
    protected void initCells() {
        this.addSpacerCell(20);
        boolean first = true;
        for (Map.Entry<String, String> m : CustomGuiHandler.getOverriddenScreens().entrySet()) {
            String overriddenScreen = m.getKey();
            String overriddenWith = m.getValue();
            if (this.removedOverrides.contains(overriddenScreen)) continue;
            if (!first) {
                this.addDescriptionEndSeparatorCell();
            }
            first = false;
            this.addLabelCell((Component)Components.translatable("fancymenu.custom_guis.manage_overridden.screen", Components.literal(overriddenScreen).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)))).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            this.addLabelCell((Component)Components.translatable("fancymenu.custom_guis.manage_overridden.overridden_with", Components.literal(overriddenWith).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)))).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Components.translatable("fancymenu.custom_guis.manage_overridden.remove_override", new Object[0]).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt())), var1 -> Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.warning(remove -> {
                if (remove.booleanValue()) {
                    this.removedOverrides.add(overriddenScreen);
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            }, LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.manage_overridden.remove_override.confirm", new String[0])))), true);
        }
        this.addSpacerCell(20);
    }

    @Override
    protected void onCancel() {
        this.onCloseRunnable.run();
    }

    @Override
    protected void onDone() {
        for (String s : this.removedOverrides) {
            CustomGuiHandler.removeScreenOverrideFor(s);
        }
        this.onCloseRunnable.run();
    }
}

