/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationControllerStateController {
    public static final File STATES_FILE = new File(FancyMenu.MOD_DIR, "/animation_controller_states.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, AnimationControllerState> STATES = new HashMap<String, AnimationControllerState>();
    private static boolean initialized = false;

    protected static void read() {
        STATES.clear();
        try {
            STATES_FILE.createNewFile();
            List<String> jsonList = FileUtils.readTextLinesFrom(STATES_FILE);
            StringBuilder json = new StringBuilder();
            jsonList.forEach(json::append);
            if (json.toString().isBlank()) {
                return;
            }
            Type type = new TypeToken<List<AnimationControllerState>>(){}.getType();
            List stateList = (List)GSON.fromJson(json.toString(), type);
            if (stateList == null) {
                return;
            }
            stateList.forEach(state -> STATES.put(Objects.requireNonNull(state.element_identifier), (AnimationControllerState)state));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to read Animation Controller states from file!", (Throwable)ex);
        }
    }

    protected static void write() {
        if (!initialized) {
            AnimationControllerStateController.read();
        }
        initialized = true;
        try {
            STATES_FILE.createNewFile();
            ArrayList<AnimationControllerState> stateList = new ArrayList<AnimationControllerState>(STATES.values());
            String json = GSON.toJson(stateList);
            FileUtils.writeTextToFile((File)STATES_FILE, (boolean)false, (String[])new String[]{Objects.requireNonNull(json)});
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to write Animation Controller states to file!", (Throwable)ex);
        }
    }

    public static void syncChanges() {
        if (!initialized) {
            AnimationControllerStateController.read();
        }
        initialized = true;
        AnimationControllerStateController.write();
    }

    public static boolean hasStateFor(@NotNull String elementIdentifier) {
        if (!initialized) {
            AnimationControllerStateController.read();
        }
        initialized = true;
        return STATES.containsKey(elementIdentifier);
    }

    @Nullable
    public static AnimationControllerState getState(@NotNull String elementIdentifier) {
        if (!initialized) {
            AnimationControllerStateController.read();
        }
        initialized = true;
        return STATES.get(elementIdentifier);
    }

    public static void putState(@NotNull String elementIdentifier, @NotNull AnimationControllerState state) {
        if (!initialized) {
            AnimationControllerStateController.read();
        }
        initialized = true;
        STATES.put(elementIdentifier, state);
        AnimationControllerStateController.syncChanges();
    }

    public static boolean isPlaying(@NotNull String elementIdentifier) {
        AnimationControllerState state = AnimationControllerStateController.getState(elementIdentifier);
        if (state == null) {
            state = new AnimationControllerState(elementIdentifier, true);
            AnimationControllerStateController.putState(elementIdentifier, state);
        }
        return state.playing;
    }

    public static boolean setPlaying(@NotNull String elementIdentifier, boolean playing) {
        AnimationControllerState state = AnimationControllerStateController.getState(elementIdentifier);
        if (state == null) {
            AnimationControllerStateController.putState(elementIdentifier, new AnimationControllerState(elementIdentifier, playing));
            return true;
        }
        if (state.playing != playing) {
            state.playing = playing;
            AnimationControllerStateController.putState(elementIdentifier, state);
            return true;
        }
        return false;
    }

    public static boolean togglePlaying(@NotNull String elementIdentifier) {
        boolean newState = !AnimationControllerStateController.isPlaying(elementIdentifier);
        AnimationControllerStateController.setPlaying(elementIdentifier, newState);
        return newState;
    }

    public static class AnimationControllerState {
        public String element_identifier;
        public boolean playing;

        public AnimationControllerState(@NotNull String element_identifier, boolean playing) {
            this.element_identifier = element_identifier;
            this.playing = playing;
        }
    }
}

