/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSlideshowScreen
extends ModernScreen {
    protected Consumer<String> callback;
    protected String selectedSlideshowName = null;
    protected ExternalTextureSlideshowRenderer selectedSlideshow = null;
    protected ScrollArea slideshowListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChooseSlideshowScreen(@Nullable String preSelectedSlideshow, @NotNull Consumer<String> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.slideshow.choose"));
        this.callback = callback;
        this.updateSlideshowScrollAreaContent();
        if (preSelectedSlideshow != null) {
            for (ScrollAreaEntry e : this.slideshowListScrollArea.getEntries()) {
                if (!(e instanceof SlideshowScrollEntry)) continue;
                SlideshowScrollEntry a = (SlideshowScrollEntry)e;
                if (!a.slideshow.equals(preSelectedSlideshow)) continue;
                a.setSelected(true);
                this.setSelectedSlideshow(a);
                break;
            }
        }
    }

    protected void m_7856_() {
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> this.callback.accept(this.selectedSlideshowName)){

            @Override
            public void m_6303_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partial) {
                if (ChooseSlideshowScreen.this.selectedSlideshowName == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((AbstractWidget)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.slideshow.choose.no_slideshow_selected", new String[0])).setDefaultStyle(), false, true);
                    this.f_93623_ = false;
                } else {
                    this.f_93623_ = true;
                }
                super.m_6303_(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        graphics.fill(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.drawString(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.slideshow.choose.available_slideshows"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.slideshowListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.slideshowListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.slideshowListScrollArea.setX(20, true);
        this.slideshowListScrollArea.setY(65, true);
        this.slideshowListScrollArea.render(graphics, mouseX, mouseY, partial);
        MutableComponent previewLabel = Component.m_237115_((String)"fancymenu.slideshow.choose.preview");
        int previewLabelWidth = this.f_96547_.m_92852_((FormattedText)previewLabel);
        graphics.drawString(this.f_96547_, (Component)previewLabel, this.f_96543_ - 20 - previewLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        if (this.selectedSlideshow != null) {
            int slideW = this.f_96543_ / 2 - 40;
            int slideH = this.f_96544_ / 2;
            AspectRatio ratio = new AspectRatio(this.selectedSlideshow.getImageWidth(), this.selectedSlideshow.getImageHeight());
            int[] size = ratio.getAspectRatioSizeByMaximumSize(slideW, slideH);
            slideW = size[0];
            slideH = size[1];
            int slideX = this.f_96543_ - 20 - slideW;
            int slideY = 65;
            graphics.fill(slideX, slideY, slideX + slideW, slideY + slideH, UIBase.getUIColorTheme().area_background_color.getColorInt());
            this.selectedSlideshow.x = slideX;
            this.selectedSlideshow.y = slideY;
            this.selectedSlideshow.width = slideW;
            this.selectedSlideshow.height = slideH;
            this.selectedSlideshow.render(graphics);
            UIBase.renderBorder(graphics, slideX, slideY, slideX + slideW, slideY + slideH, 1, UIBase.getUIColorTheme().element_border_color_normal.getColor(), true, true, true, true);
        }
        this.doneButton.f_93620_ = this.f_96543_ - 20 - this.doneButton.m_5711_();
        this.doneButton.f_93621_ = this.f_96544_ - 20 - 20;
        this.doneButton.m_6305_(graphics.pose(), mouseX, mouseY, partial);
        this.cancelButton.f_93620_ = this.f_96543_ - 20 - this.cancelButton.m_5711_();
        this.cancelButton.f_93621_ = this.doneButton.f_93621_ - 5 - 20;
        this.cancelButton.m_6305_(graphics.pose(), mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    protected void setSelectedSlideshow(@Nullable SlideshowScrollEntry entry) {
        if (entry == null) {
            this.selectedSlideshow = null;
            this.selectedSlideshowName = null;
            return;
        }
        this.selectedSlideshowName = entry.slideshow;
        this.selectedSlideshow = SlideshowHandler.getSlideshow(entry.slideshow);
        if (this.selectedSlideshow != null && !this.selectedSlideshow.isReady()) {
            this.selectedSlideshow.prepareSlideshow();
        }
    }

    protected void updateSlideshowScrollAreaContent() {
        this.slideshowListScrollArea.clearEntries();
        for (String s : SlideshowHandler.getSlideshowNames()) {
            ScrollAreaEntry e = new SlideshowScrollEntry(this.slideshowListScrollArea, s, entry -> this.setSelectedSlideshow((SlideshowScrollEntry)entry));
            this.slideshowListScrollArea.addEntry(e);
        }
        if (this.slideshowListScrollArea.getEntries().isEmpty()) {
            this.slideshowListScrollArea.addEntry(new TextScrollAreaEntry(this.slideshowListScrollArea, (Component)Component.m_237115_((String)"fancymenu.slideshow.choose.no_slideshows"), entry -> {}));
        }
        int totalWidth = this.slideshowListScrollArea.getTotalEntryWidth();
        for (ScrollAreaEntry e : this.slideshowListScrollArea.getEntries()) {
            e.setWidth(totalWidth);
        }
    }

    public boolean m_7933_(int button, int $$1, int $$2) {
        if (button == 257 && this.selectedSlideshowName != null) {
            this.callback.accept(this.selectedSlideshowName);
            return true;
        }
        return super.m_7933_(button, $$1, $$2);
    }

    public static class SlideshowScrollEntry
    extends TextListScrollAreaEntry {
        public String slideshow;

        public SlideshowScrollEntry(ScrollArea parent, @NotNull String slideshow, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Component.m_237113_((String)slideshow).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.slideshow = slideshow;
        }
    }
}

