/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnBlockBrokeListener
extends AbstractListener {
    @Nullable
    private BlockPos lastBlockPos;
    @Nullable
    private String cachedBlockKey;
    @Nullable
    private String cachedToolKey;

    public OnBlockBrokeListener() {
        super("block_broke");
    }

    public void onBlockBroke(@NotNull BlockPos blockPos, @NotNull BlockState blockState, @Nullable String brokeWithItemKey) {
        this.lastBlockPos = blockPos.m_7949_();
        ResourceLocation blockKeyLocation = Registry.f_122824_.m_7981_((Object)blockState.m_60734_());
        this.cachedBlockKey = blockKeyLocation != null ? blockKeyLocation.toString() : null;
        this.cachedToolKey = brokeWithItemKey != null && !brokeWithItemKey.isBlank() ? brokeWithItemKey : null;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("broke_with_item_key", () -> this.cachedToolKey != null ? this.cachedToolKey : "EMPTY"));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.m_123341_()) : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.m_123342_()) : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.m_123343_()) : "0"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_block_broke");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_block_broke.desc", new String[0]));
    }
}

