/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnEntityStopsBeingInSightListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnEntityStartsBeingInSightListener
extends AbstractListener {
    private final OnEntityStopsBeingInSightListener stopListener;
    private final Map<UUID, EntitySightData> trackedEntities = new HashMap<UUID, EntitySightData>();
    private final Set<UUID> seenThisFrame = new HashSet<UUID>();
    @Nullable
    private EntitySightData cachedEntityData;

    public OnEntityStartsBeingInSightListener(@NotNull OnEntityStopsBeingInSightListener stopListener) {
        super("entity_starts_being_in_sight");
        this.stopListener = stopListener;
    }

    public void onRenderFrameStart() {
        this.seenThisFrame.clear();
    }

    public void onEntityVisible(@NotNull Entity entity, double distanceToPlayer) {
        UUID entityUuid = entity.m_20148_();
        EntitySightData sightData = EntitySightData.from(entity, distanceToPlayer);
        this.seenThisFrame.add(entityUuid);
        EntitySightData previousData = this.trackedEntities.put(entityUuid, sightData);
        if (previousData != null) {
            return;
        }
        this.cachedEntityData = sightData;
        this.notifyAllInstances();
    }

    public void onRenderFrameEnd() {
        if (this.trackedEntities.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, EntitySightData>> iterator = this.trackedEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, EntitySightData> entry = iterator.next();
            if (this.seenThisFrame.contains(entry.getKey())) continue;
            iterator.remove();
            this.stopListener.onEntityStopped(entry.getValue());
        }
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null || data.entityKey() == null) {
                return "ERROR";
            }
            return data.entityKey();
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distanceToPlayer());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosX());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosY());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosZ());
        }));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> {
            EntitySightData data = this.cachedEntityData;
            if (data == null) {
                return "ERROR";
            }
            return data.entityUuid().toString();
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_entity_starts_being_in_sight");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_starts_being_in_sight.desc", new String[0]));
    }

    public record EntitySightData(@Nullable String entityKey, double distanceToPlayer, double entityPosX, double entityPosY, double entityPosZ, @NotNull UUID entityUuid) {
        @NotNull
        public static EntitySightData from(@NotNull Entity entity, double distanceToPlayer) {
            ResourceLocation entityTypeKey = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
            String keyString = entityTypeKey != null ? entityTypeKey.toString() : null;
            return new EntitySightData(keyString, distanceToPlayer, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20148_());
        }
    }
}

