/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnEntityUnmountedListener
extends AbstractListener {
    @Nullable
    private String cachedEntityKey;
    @Nullable
    private String cachedEntityPosX;
    @Nullable
    private String cachedEntityPosY;
    @Nullable
    private String cachedEntityPosZ;
    @Nullable
    private String cachedEntityUuid;

    public OnEntityUnmountedListener() {
        super("entity_unmounted");
    }

    public void onEntityUnmounted(@Nullable Entity entity) {
        if (entity != null) {
            this.cacheEntityData(entity);
        } else {
            this.cachedEntityKey = null;
            this.cachedEntityPosX = null;
            this.cachedEntityPosY = null;
            this.cachedEntityPosZ = null;
            this.cachedEntityUuid = null;
        }
        this.notifyAllInstances();
    }

    private void cacheEntityData(@NotNull Entity entity) {
        ResourceLocation entityKey = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
        this.cachedEntityKey = entityKey != null ? entityKey.toString() : null;
        this.cachedEntityPosX = Double.toString(entity.m_20185_());
        this.cachedEntityPosY = Double.toString(entity.m_20186_());
        this.cachedEntityPosZ = Double.toString(entity.m_20189_());
        this.cachedEntityUuid = entity.m_20148_().toString();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> this.cachedEntityKey != null ? this.cachedEntityKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> this.cachedEntityPosX != null ? this.cachedEntityPosX : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> this.cachedEntityPosY != null ? this.cachedEntityPosY : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> this.cachedEntityPosZ != null ? this.cachedEntityPosZ : "0"));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> this.cachedEntityUuid != null ? this.cachedEntityUuid : "ERROR"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_entity_unmounted");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_unmounted.desc", new String[0]));
    }
}

