/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnWorldSoundTriggeredListener
extends AbstractListener {
    @Nullable
    private String cachedSoundResourceLocation;
    @Nullable
    private String cachedSoundDisplayName;
    @Nullable
    private String cachedSoundOriginPosX;
    @Nullable
    private String cachedSoundOriginPosY;
    @Nullable
    private String cachedSoundOriginPosZ;
    @Nullable
    private String cachedSoundOriginDistanceToPlayer;
    @Nullable
    private String cachedSoundOriginDirectionFromPlayer;

    public OnWorldSoundTriggeredListener() {
        super("world_sound_triggered");
    }

    public void onWorldSoundTriggered(@NotNull SoundInstance sound, @Nullable Component subtitle, float audibleRange) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (minecraft.f_91073_ == null || player == null) {
            return;
        }
        if (sound.m_7796_()) {
            return;
        }
        if (!Float.isFinite(audibleRange)) {
            return;
        }
        Vec3 soundPosition = new Vec3(sound.m_7772_(), sound.m_7780_(), sound.m_7778_());
        Vec3 playerPosition = player.m_20182_();
        double distanceToPlayer = soundPosition.m_82554_(playerPosition);
        this.cachedSoundResourceLocation = this.resolveSoundResourceLocation(sound);
        this.cachedSoundDisplayName = this.resolveDisplayName(subtitle, this.cachedSoundResourceLocation);
        this.cachedSoundOriginPosX = Double.toString(soundPosition.f_82479_);
        this.cachedSoundOriginPosY = Double.toString(soundPosition.f_82480_);
        this.cachedSoundOriginPosZ = Double.toString(soundPosition.f_82481_);
        this.cachedSoundOriginDistanceToPlayer = Double.toString(distanceToPlayer);
        this.cachedSoundOriginDirectionFromPlayer = Double.toString(this.calculateDirectionDegrees(player, soundPosition));
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("sound_resource_location", () -> this.cachedSoundResourceLocation != null ? this.cachedSoundResourceLocation : "ERROR"));
        list.add(new AbstractListener.CustomVariable("sound_display_name", () -> this.cachedSoundDisplayName != null ? this.cachedSoundDisplayName : "UNKNOWN"));
        list.add(new AbstractListener.CustomVariable("sound_origin_pos_x", () -> this.cachedSoundOriginPosX != null ? this.cachedSoundOriginPosX : "0"));
        list.add(new AbstractListener.CustomVariable("sound_origin_pos_y", () -> this.cachedSoundOriginPosY != null ? this.cachedSoundOriginPosY : "0"));
        list.add(new AbstractListener.CustomVariable("sound_origin_pos_z", () -> this.cachedSoundOriginPosZ != null ? this.cachedSoundOriginPosZ : "0"));
        list.add(new AbstractListener.CustomVariable("sound_origin_distance_to_player", () -> this.cachedSoundOriginDistanceToPlayer != null ? this.cachedSoundOriginDistanceToPlayer : "0"));
        list.add(new AbstractListener.CustomVariable("sound_origin_direction_from_player", () -> this.cachedSoundOriginDirectionFromPlayer != null ? this.cachedSoundOriginDirectionFromPlayer : "0"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_world_sound_triggered");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_world_sound_triggered.desc", new String[0]));
    }

    @Nullable
    private String resolveSoundResourceLocation(@NotNull SoundInstance sound) {
        ResourceLocation fallback;
        Sound resolvedSound = sound.m_5891_();
        if (resolvedSound != null && resolvedSound != SoundManager.f_120344_) {
            ResourceLocation path = resolvedSound.m_119790_();
            if (path != null) {
                return path.toString();
            }
            ResourceLocation directLocation = resolvedSound.m_119787_();
            if (directLocation != null) {
                return directLocation.toString();
            }
        }
        return (fallback = sound.m_7904_()) != null ? fallback.toString() : null;
    }

    @NotNull
    private String resolveDisplayName(@Nullable Component subtitle, @Nullable String fallback) {
        String plain;
        if (subtitle != null && !(plain = subtitle.getString()).isBlank()) {
            return plain;
        }
        if (fallback != null && !fallback.isBlank()) {
            return fallback;
        }
        return "UNKNOWN";
    }

    private double calculateDirectionDegrees(@NotNull LocalPlayer player, @NotNull Vec3 soundPosition) {
        Vec3 playerPosition = player.m_20182_();
        double deltaX = soundPosition.f_82479_ - playerPosition.f_82479_;
        double deltaZ = soundPosition.f_82481_ - playerPosition.f_82481_;
        if (Math.abs(deltaX) < 1.0E-6 && Math.abs(deltaZ) < 1.0E-6) {
            return 0.0;
        }
        double angleToSound = Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0;
        double relative = Mth.m_14175_((double)(angleToSound - (double)player.m_146908_()));
        double normalized = relative % 360.0;
        if (normalized < 0.0) {
            normalized += 360.0;
        }
        return normalized;
    }
}

