/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.widget.RenderWidgetBackgroundEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VanillaButtonHandler {
    private static final Map<AbstractWidget, ResourceLocation> BACKGROUND_TEXTURES = new HashMap<AbstractWidget, ResourceLocation>();
    private static final Map<AbstractWidget, VanillaBackgroundAnimation> BACKGROUND_ANIMATIONS = new HashMap<AbstractWidget, VanillaBackgroundAnimation>();

    public static void init() {
        EventHandler.INSTANCE.registerListenersOf(new VanillaButtonHandler());
    }

    public static void setRenderTickBackgroundTexture(AbstractWidget widget, ResourceLocation background) {
        if (background != null) {
            BACKGROUND_TEXTURES.put(widget, background);
        } else {
            BACKGROUND_TEXTURES.remove(widget);
        }
    }

    public static void setRenderTickBackgroundAnimation(AbstractWidget widget, IAnimationRenderer background, boolean loop, float opacity) {
        if (background != null) {
            BACKGROUND_ANIMATIONS.put(widget, new VanillaBackgroundAnimation(background, loop, opacity));
        } else {
            BACKGROUND_ANIMATIONS.remove(widget);
        }
    }

    @EventListener
    public void onRenderButtonBackgroundPre(RenderWidgetBackgroundEvent.Pre e) {
        AbstractWidget w = e.getWidget();
        ResourceLocation backgroundTexture = BACKGROUND_TEXTURES.get(w);
        VanillaBackgroundAnimation backgroundAnimation = BACKGROUND_ANIMATIONS.get(w);
        RenderSystem.m_69478_();
        if (backgroundTexture != null) {
            RenderUtils.bindTexture((ResourceLocation)backgroundTexture);
            GuiComponent.m_93133_((PoseStack)e.getPoseStack(), (int)w.f_93620_, (int)w.f_93621_, (float)0.0f, (float)0.0f, (int)w.m_5711_(), (int)w.m_93694_(), (int)w.m_5711_(), (int)w.m_93694_());
        }
        if (backgroundTexture == null && backgroundAnimation != null) {
            boolean loop = backgroundAnimation.animationRenderer.isGettingLooped();
            int aw = backgroundAnimation.animationRenderer.getWidth();
            int ah = backgroundAnimation.animationRenderer.getHeight();
            int ax = backgroundAnimation.animationRenderer.getPosX();
            int ay = backgroundAnimation.animationRenderer.getPosY();
            backgroundAnimation.animationRenderer.setWidth(w.m_5711_());
            backgroundAnimation.animationRenderer.setHeight(w.m_93694_());
            backgroundAnimation.animationRenderer.setPosX(w.f_93620_);
            backgroundAnimation.animationRenderer.setPosY(w.f_93621_);
            backgroundAnimation.animationRenderer.setOpacity(backgroundAnimation.opacity);
            backgroundAnimation.animationRenderer.setLooped(backgroundAnimation.loop);
            backgroundAnimation.animationRenderer.render(e.getPoseStack());
            backgroundAnimation.animationRenderer.setWidth(aw);
            backgroundAnimation.animationRenderer.setHeight(ah);
            backgroundAnimation.animationRenderer.setPosX(ax);
            backgroundAnimation.animationRenderer.setPosY(ay);
            backgroundAnimation.animationRenderer.setOpacity(1.0f);
            backgroundAnimation.animationRenderer.setLooped(loop);
        }
        if (backgroundTexture != null || backgroundAnimation != null) {
            if (w instanceof ImageButton) {
                Component msg = w.m_6035_();
                int j = w.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
                GuiComponent.m_93215_((PoseStack)e.getPoseStack(), (Font)Minecraft.m_91087_().f_91062_, (Component)msg, (int)(w.f_93620_ + w.m_5711_() / 2), (int)(w.f_93621_ + (w.m_93694_() - 8) / 2), (int)(j | Mth.m_14167_((float)(e.getAlpha() * 255.0f)) << 24));
            }
            e.setCanceled(true);
        }
    }

    @EventListener(priority=-100)
    public void onRenderScreenPost(RenderScreenEvent.Post e) {
        BACKGROUND_TEXTURES.clear();
        BACKGROUND_ANIMATIONS.clear();
    }

    protected static class VanillaBackgroundAnimation {
        protected IAnimationRenderer animationRenderer;
        protected boolean loop;
        protected float opacity;

        protected VanillaBackgroundAnimation(IAnimationRenderer animationRenderer, boolean loop, float opacity) {
            this.animationRenderer = animationRenderer;
            this.loop = loop;
            this.opacity = opacity;
        }
    }
}

