/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")})
    private void before_sendChat_FancyMenu(Packet<?> packet, CallbackInfo ci) {
        if (!(packet instanceof ServerboundChatPacket)) {
            return;
        }
        ServerboundChatPacket chatPacket = (ServerboundChatPacket)packet;
        Listeners.ON_CHAT_MESSAGE_SENT.onChatMessageSent((Component)Component.m_237113_((String)chatPacket.f_133827_()));
    }

    @Inject(method={"handlePlayerInfo"}, at={@At(value="HEAD")})
    private void before_handlePlayerInfoUpdate_FancyMenu(ClientboundPlayerInfoPacket packet, CallbackInfo ci) {
        if (packet.m_132735_() != ClientboundPlayerInfoPacket.Action.ADD_PLAYER) {
            return;
        }
        UUID localProfileId = Minecraft.m_91087_().m_91094_().m_240411_();
        for (ClientboundPlayerInfoPacket.PlayerUpdate entry : packet.m_132732_()) {
            UUID profileId;
            GameProfile profile = entry.m_132763_();
            if (profile == null || (profileId = profile.getId()) == null || profileId.equals(localProfileId)) continue;
            Listeners.ON_OTHER_PLAYER_JOINED_WORLD.onOtherPlayerJoined(profile.getName(), profileId);
        }
    }

    @Inject(method={"handlePlayerInfo"}, at={@At(value="HEAD")})
    private void before_handlePlayerInfoRemove_FancyMenu(ClientboundPlayerInfoPacket packet, CallbackInfo ci) {
        if (packet.m_132735_() != ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER) {
            return;
        }
        UUID localProfileId = Minecraft.m_91087_().m_91094_().m_240411_();
        ClientPacketListener self = (ClientPacketListener)this;
        for (ClientboundPlayerInfoPacket.PlayerUpdate entry : packet.m_132732_()) {
            UUID profileId;
            GameProfile profile = entry.m_132763_();
            if (profile == null || (profileId = profile.getId()) == null || profileId.equals(localProfileId)) continue;
            PlayerInfo playerInfo = self.m_104949_(profileId);
            String playerName = profile.getName();
            if ((playerName == null || playerName.isBlank()) && playerInfo != null) {
                playerName = playerInfo.m_105312_().getName();
            }
            Listeners.ON_OTHER_PLAYER_LEFT_WORLD.onOtherPlayerLeft(playerName, profileId);
        }
    }

    @Inject(method={"handlePlayerCombatKill"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)})
    private void after_handlePlayerCombatKillEnsureThread_FancyMenu(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        Player player;
        block6: {
            block5: {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91073_ == null) {
                    return;
                }
                Entity entity = minecraft.f_91073_.m_6815_(packet.m_179078_());
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (entity != minecraft.f_91074_) break block6;
            }
            return;
        }
        Vec3 deathPosition = player.m_20182_();
        String playerName = player.m_36316_().getName();
        if ((playerName == null || playerName.isBlank()) && player.m_7755_() != null) {
            playerName = player.m_7755_().getString();
        }
        Listeners.ON_OTHER_PLAYER_DIED.onOtherPlayerDied(playerName, player.m_20148_(), deathPosition);
    }

    @Inject(method={"handlePlayerCombatKill"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", shift=At.Shift.AFTER)})
    private void after_handlePlayerCombatKillSetScreen_FancyMenu(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        int ticksSinceDeath;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        Long daysSurvived = null;
        StatsCounter stats = minecraft.f_91074_.m_108630_();
        if (stats != null && (ticksSinceDeath = stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_))) >= 0) {
            daysSurvived = ticksSinceDeath / 24000;
        }
        Vec3 deathPosition = minecraft.f_91074_.m_20182_();
        Listeners.ON_DEATH.onDeath(packet.m_179079_(), daysSurvived, deathPosition.f_82479_, deathPosition.f_82480_, deathPosition.f_82481_);
    }

    @WrapOperation(method={"handleTakeItemEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")})
    private void wrap_shrinkItem_FancyMenu(ItemStack stack, int amount, Operation<Void> operation, ClientboundTakeItemEntityPacket packet) {
        ResourceLocation itemLocation;
        boolean isLocalCollector;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            operation.call(new Object[]{stack, amount});
            return;
        }
        ClientLevel level = minecraft.f_91073_;
        Entity potentialCollector = level != null ? level.m_6815_(packet.m_133527_()) : null;
        boolean bl = isLocalCollector = potentialCollector == localPlayer;
        if (!isLocalCollector && potentialCollector == null) {
            isLocalCollector = packet.m_133527_() == localPlayer.m_19879_();
        }
        String itemKey = null;
        if (!stack.m_41619_() && (itemLocation = Registry.f_122827_.m_7981_((Object)stack.m_41720_())) != null) {
            itemKey = itemLocation.toString();
        }
        operation.call(new Object[]{stack, amount});
        if (!isLocalCollector || itemKey == null) {
            return;
        }
        Listeners.ON_ITEM_PICKED_UP.onItemPickedUp(itemKey);
    }
}

