/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    @Unique
    private ItemStack lastBrokenStack_FancyMenu = ItemStack.f_41583_;
    @Unique
    private String lastBrokenItemType_FancyMenu;

    @Inject(method={"onEffectAdded"}, at={@At(value="TAIL")})
    private void after_onEffectAdded_FancyMenu(MobEffectInstance effectInstance, @Nullable Entity entity, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof LocalPlayer)) {
            return;
        }
        MobEffect effect = effectInstance.m_19544_();
        String effectKey = this.resolveEffectKey_FancyMenu(effect);
        String effectType = this.resolveEffectTypeName_FancyMenu(effect);
        Listeners.ON_EFFECT_GAINED.onEffectGained(effectKey, effectType, effectInstance.m_19557_());
    }

    @WrapOperation(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack wrap_finishUsingItem_FancyMenu(ItemStack stack, Level level, LivingEntity living, Operation<ItemStack> operation) {
        ResourceLocation itemLocation;
        String itemKey = null;
        if (!stack.m_41619_() && (itemLocation = Registry.f_122827_.m_7981_((Object)stack.m_41720_())) != null) {
            itemKey = itemLocation.toString();
        }
        ItemStack result = (ItemStack)operation.call(new Object[]{stack, level, living});
        if (itemKey != null && living instanceof LocalPlayer) {
            Listeners.ON_ITEM_CONSUMED.onItemConsumed(itemKey);
        }
        return result;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;breakItem(Lnet/minecraft/world/item/ItemStack;)V")})
    private void before_breakItem_FancyMenu(byte eventId, CallbackInfo ci) {
        this.captureBrokenItem_FancyMenu(eventId);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;breakItem(Lnet/minecraft/world/item/ItemStack;)V", shift=At.Shift.AFTER)})
    private void after_breakItem_FancyMenu(byte eventId, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof LocalPlayer) || this.lastBrokenStack_FancyMenu.m_41619_()) {
            this.clearBrokenItemCache_FancyMenu();
            return;
        }
        ResourceLocation itemLocation = Registry.f_122827_.m_7981_((Object)this.lastBrokenStack_FancyMenu.m_41720_());
        String itemKey = itemLocation != null ? itemLocation.toString() : null;
        Listeners.ON_ITEM_BROKE.onItemBroke(itemKey, this.lastBrokenItemType_FancyMenu);
        this.clearBrokenItemCache_FancyMenu();
    }

    @Unique
    private void captureBrokenItem_FancyMenu(byte eventId) {
        this.clearBrokenItemCache_FancyMenu();
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)self;
        EquipmentSlot slot = this.mapEquipmentSlot_FancyMenu(eventId);
        if (slot == null) {
            return;
        }
        ItemStack stack = localPlayer.m_6844_(slot);
        if (stack.m_41619_()) {
            return;
        }
        this.lastBrokenStack_FancyMenu = stack.m_41777_();
        this.lastBrokenItemType_FancyMenu = this.resolveItemType_FancyMenu(slot, stack);
    }

    @Unique
    private void clearBrokenItemCache_FancyMenu() {
        this.lastBrokenStack_FancyMenu = ItemStack.f_41583_;
        this.lastBrokenItemType_FancyMenu = null;
    }

    @Unique
    private EquipmentSlot mapEquipmentSlot_FancyMenu(byte eventId) {
        return switch (eventId) {
            case 47 -> EquipmentSlot.MAINHAND;
            case 48 -> EquipmentSlot.OFFHAND;
            case 49 -> EquipmentSlot.HEAD;
            case 50 -> EquipmentSlot.CHEST;
            case 51 -> EquipmentSlot.LEGS;
            case 52 -> EquipmentSlot.FEET;
            default -> null;
        };
    }

    @Unique
    private String resolveEffectTypeName_FancyMenu(MobEffect effect) {
        MobEffectCategory category = effect.m_19483_();
        return switch (category) {
            default -> throw new IncompatibleClassChangeError();
            case MobEffectCategory.BENEFICIAL -> "positive";
            case MobEffectCategory.HARMFUL -> "negative";
            case MobEffectCategory.NEUTRAL -> "neutral";
        };
    }

    @Unique
    private String resolveEffectKey_FancyMenu(MobEffect effect) {
        ResourceLocation effectLocation = Registry.f_122823_.m_7981_((Object)effect);
        return effectLocation != null ? effectLocation.toString() : "unknown";
    }

    @Unique
    private String resolveItemType_FancyMenu(EquipmentSlot slot, ItemStack stack) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            return "armor";
        }
        if ((slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) && stack.m_41763_()) {
            return "tool";
        }
        return "other";
    }
}

