/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.elements.musiccontroller.MusicControllerHandler;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MixinMusicManager {
    @Unique
    @Nullable
    private SoundInstance pendingStoppedMusic_FancyMenu;
    @Unique
    @Nullable
    private String currentTrackResourceLocation_FancyMenu;
    @Unique
    @Nullable
    private String currentTrackEventLocation_FancyMenu;
    @Shadow
    @Nullable
    private SoundInstance f_120179_;

    @Unique
    private void fireMusicTrackStartedFancyMenu(@Nullable SoundInstance soundInstance) {
        String trackLocation;
        String eventLocation = this.extractEventResourceLocationFancyMenu(soundInstance);
        this.currentTrackResourceLocation_FancyMenu = trackLocation = this.extractTrackResourceLocationFancyMenu(soundInstance);
        this.currentTrackEventLocation_FancyMenu = eventLocation;
        if (trackLocation != null || eventLocation != null) {
            Listeners.ON_MUSIC_TRACK_STARTED.onMusicTrackStarted(trackLocation, eventLocation);
        }
    }

    @Unique
    private void fireMusicTrackStoppedFancyMenu(@Nullable SoundInstance soundInstance) {
        String trackLocation;
        String eventLocation = this.extractEventResourceLocationFancyMenu(soundInstance);
        if (eventLocation == null) {
            eventLocation = this.currentTrackEventLocation_FancyMenu;
        }
        if ((trackLocation = this.extractTrackResourceLocationFancyMenu(soundInstance)) == null) {
            trackLocation = this.currentTrackResourceLocation_FancyMenu;
        }
        this.currentTrackResourceLocation_FancyMenu = null;
        this.currentTrackEventLocation_FancyMenu = null;
        if (trackLocation != null || eventLocation != null) {
            Listeners.ON_MUSIC_TRACK_STOPPED.onMusicTrackStopped(trackLocation, eventLocation);
        }
    }

    @Unique
    @Nullable
    private String extractTrackResourceLocationFancyMenu(@Nullable SoundInstance soundInstance) {
        ResourceLocation fallback;
        if (soundInstance == null) {
            return null;
        }
        Sound sound = soundInstance.m_5891_();
        if (sound != null && sound != SoundManager.f_120344_) {
            ResourceLocation resolvedPath = sound.m_119790_();
            if (resolvedPath != null) {
                return resolvedPath.toString();
            }
            ResourceLocation resolvedLocation = sound.m_119787_();
            if (resolvedLocation != null) {
                return resolvedLocation.toString();
            }
        }
        return (fallback = soundInstance.m_7904_()) != null ? fallback.toString() : null;
    }

    @Unique
    @Nullable
    private String extractEventResourceLocationFancyMenu(@Nullable SoundInstance soundInstance) {
        if (soundInstance == null) {
            return null;
        }
        ResourceLocation location = soundInstance.m_7904_();
        return location != null ? location.toString() : null;
    }

    @Shadow
    public abstract void m_120186_();

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelTickIfMusicDisabledViaController_FancyMenu(CallbackInfo info) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            if (!MusicControllerHandler.shouldPlayMenuMusic()) {
                info.cancel();
            }
        } else if (!MusicControllerHandler.shouldPlayWorldMusic()) {
            info.cancel();
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopMusicIfDisabledInConfigFancyMenu(Music music, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91073_ == null && !FancyMenu.getOptions().playVanillaMenuMusic.getValue().booleanValue()) {
            this.m_120186_();
            info.cancel();
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="RETURN")})
    private void after_startPlayingFancyMenu(Music music, CallbackInfo info) {
        if (this.f_120179_ != null && this.f_120179_.m_5891_() != SoundManager.f_120344_) {
            this.fireMusicTrackStartedFancyMenu(this.f_120179_);
        } else {
            this.currentTrackResourceLocation_FancyMenu = null;
            this.currentTrackEventLocation_FancyMenu = null;
        }
    }

    @Inject(method={"stopPlaying()V"}, at={@At(value="HEAD")})
    private void before_stopPlayingFancyMenu(CallbackInfo info) {
        this.pendingStoppedMusic_FancyMenu = this.f_120179_;
    }

    @Inject(method={"stopPlaying()V"}, at={@At(value="RETURN")})
    private void after_stopPlayingFancyMenu(CallbackInfo info) {
        if (this.pendingStoppedMusic_FancyMenu != null) {
            this.fireMusicTrackStoppedFancyMenu(this.pendingStoppedMusic_FancyMenu);
        }
        this.pendingStoppedMusic_FancyMenu = null;
    }

    @WrapOperation(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/client/sounds/MusicManager;currentMusic:Lnet/minecraft/client/resources/sounds/SoundInstance;", opcode=181)})
    private void wrap_setCurrentMusicFancyMenu(MusicManager instance, SoundInstance value, Operation<Void> operation) {
        SoundInstance previous = this.f_120179_;
        operation.call(new Object[]{instance, value});
        if (previous != null && value == null) {
            this.fireMusicTrackStoppedFancyMenu(previous);
        } else if (value != null) {
            this.currentTrackResourceLocation_FancyMenu = this.extractTrackResourceLocationFancyMenu(value);
            this.currentTrackEventLocation_FancyMenu = this.extractEventResourceLocationFancyMenu(value);
        }
    }
}

