/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.rendering.gui.ClientTooltipPositioner;
import de.keksuccino.fancymenu.util.rendering.gui.DefaultTooltipPositioner;
import de.keksuccino.fancymenu.util.rendering.gui.Divisor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiMatrix4f;
import de.keksuccino.fancymenu.util.rendering.gui.GuiRenderTypes;
import de.keksuccino.fancymenu.util.rendering.gui.ScreenRectangle;
import de.keksuccino.fancymenu.util.rendering.gui.TooltipRenderUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

public class GuiGraphics {
    public static final Screen DUMMY_SCREEN = ObjectUtils.build(() -> {
        TitleScreen s = new TitleScreen();
        s.m_6575_(Minecraft.m_91087_(), 1000, 1000);
        return s;
    });
    public static final GuiComponent GUI_COMPONENT = new GuiComponent(){

        protected void m_93154_(PoseStack $$0, int $$1, int $$2, int $$3, int $$4) {
            super.m_93154_($$0, $$1, $$2, $$3, $$4);
        }
    };
    public static final float MAX_GUI_Z = 10000.0f;
    public static final float MIN_GUI_Z = -10000.0f;
    private static final int EXTRA_SPACE_AFTER_FIRST_TOOLTIP_LINE = 2;
    private final Minecraft minecraft;
    private final PoseStack pose;
    private final MultiBufferSource.BufferSource bufferSource;
    private final ScissorStack scissorStack = new ScissorStack();
    private boolean managed;
    protected static GuiGraphics currentGraphics = null;

    @NotNull
    public static GuiGraphics updateGraphicsAndGet(@NotNull PoseStack pose, @NotNull MultiBufferSource.BufferSource bufferSource) {
        currentGraphics = new GuiGraphics(Minecraft.m_91087_(), pose, bufferSource);
        return currentGraphics;
    }

    public static GuiGraphics currentGraphics() {
        return currentGraphics;
    }

    private GuiGraphics(Minecraft minecraft, PoseStack pose, MultiBufferSource.BufferSource bufferSource) {
        this.minecraft = minecraft;
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public GuiGraphics(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource) {
        this(minecraft, new PoseStack(), bufferSource);
    }

    public MultiBufferSource.BufferSource getBufferSource() {
        return this.bufferSource;
    }

    public void drawManaged(Runnable runnable) {
        this.flush();
        this.managed = true;
        runnable.run();
        this.managed = false;
        this.flush();
    }

    private void flushIfUnmanaged() {
        if (!this.managed) {
            this.flush();
        }
    }

    private void flushIfManaged() {
        if (this.managed) {
            this.flush();
        }
    }

    public int guiWidth() {
        return this.minecraft.m_91268_().m_85445_();
    }

    public int guiHeight() {
        return this.minecraft.m_91268_().m_85446_();
    }

    public PoseStack pose() {
        return this.pose;
    }

    public MultiBufferSource.BufferSource bufferSource() {
        return this.bufferSource;
    }

    public void flush() {
        RenderSystem.m_69465_();
        this.bufferSource.m_109911_();
        RenderSystem.m_69482_();
    }

    public void hLine(int minX, int maxX, int y, int color) {
        this.hLine(GuiRenderTypes.gui(), minX, maxX, y, color);
    }

    public void hLine(RenderType renderType, int minX, int maxX, int y, int color) {
        if (maxX < minX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        this.fill(renderType, minX, y, maxX + 1, y + 1, color);
    }

    public void vLine(int x, int minY, int maxY, int color) {
        this.vLine(GuiRenderTypes.gui(), x, minY, maxY, color);
    }

    public void vLine(RenderType renderType, int x, int minY, int maxY, int color) {
        if (maxY < minY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }
        this.fill(renderType, x, minY + 1, x + 1, maxY, color);
    }

    public void enableScissor(int minX, int minY, int maxX, int maxY) {
        this.applyScissor(this.scissorStack.push(new ScreenRectangle(minX, minY, maxX - minX, maxY - minY)));
    }

    public void disableScissor() {
        this.applyScissor(this.scissorStack.pop());
    }

    private void applyScissor(@Nullable ScreenRectangle rectangle) {
        this.flushIfManaged();
        if (rectangle != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            int i = window.m_85442_();
            double d = window.m_85449_();
            double e = (double)rectangle.left() * d;
            double f = (double)i - (double)rectangle.bottom() * d;
            double g = (double)rectangle.width() * d;
            double h = (double)rectangle.height() * d;
            RenderSystem.m_69488_((int)((int)e), (int)((int)f), (int)Math.max(0, (int)g), (int)Math.max(0, (int)h));
        } else {
            RenderSystem.m_69471_();
        }
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfManaged();
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(GuiRenderTypes.gui(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.fill(renderType, minX, minY, maxX, maxY, 0, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        int i;
        Matrix4f matrix4F = this.pose.m_85850_().m_85861_();
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        float f = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float h = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float j = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        VertexConsumer vertexConsumer = this.bufferSource.m_6299_(renderType);
        vertexConsumer.m_85982_(matrix4F, (float)minX, (float)minY, (float)z).m_85950_(g, h, j, f).m_5752_();
        vertexConsumer.m_85982_(matrix4F, (float)minX, (float)maxY, (float)z).m_85950_(g, h, j, f).m_5752_();
        vertexConsumer.m_85982_(matrix4F, (float)maxX, (float)maxY, (float)z).m_85950_(g, h, j, f).m_5752_();
        vertexConsumer.m_85982_(matrix4F, (float)maxX, (float)minY, (float)z).m_85950_(g, h, j, f).m_5752_();
        this.flushIfUnmanaged();
    }

    public void fillGradient(int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        this.fillGradient(x1, y1, x2, y2, 0, colorFrom, colorTo);
    }

    public void fillGradient(int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        this.fillGradient(GuiRenderTypes.gui(), x1, y1, x2, y2, colorFrom, colorTo, z);
    }

    public void fillGradient(RenderType renderType, int x1, int y1, int x2, int y2, int colorFrom, int colorTo, int z) {
        VertexConsumer vertexConsumer = this.bufferSource.m_6299_(renderType);
        this.fillGradient(vertexConsumer, x1, y1, x2, y2, z, colorFrom, colorTo);
        this.flushIfUnmanaged();
    }

    private void fillGradient(VertexConsumer consumer, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        float f = (float)FastColor.ARGB32.m_13655_((int)colorFrom) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13665_((int)colorFrom) / 255.0f;
        float h = (float)FastColor.ARGB32.m_13667_((int)colorFrom) / 255.0f;
        float i = (float)FastColor.ARGB32.m_13669_((int)colorFrom) / 255.0f;
        float j = (float)FastColor.ARGB32.m_13655_((int)colorTo) / 255.0f;
        float k = (float)FastColor.ARGB32.m_13665_((int)colorTo) / 255.0f;
        float l = (float)FastColor.ARGB32.m_13667_((int)colorTo) / 255.0f;
        float m = (float)FastColor.ARGB32.m_13669_((int)colorTo) / 255.0f;
        Matrix4f matrix4F = this.pose.m_85850_().m_85861_();
        consumer.m_85982_(matrix4F, (float)x1, (float)y1, (float)z).m_85950_(g, h, i, f).m_5752_();
        consumer.m_85982_(matrix4F, (float)x1, (float)y2, (float)z).m_85950_(k, l, m, j).m_5752_();
        consumer.m_85982_(matrix4F, (float)x2, (float)y2, (float)z).m_85950_(k, l, m, j).m_5752_();
        consumer.m_85982_(matrix4F, (float)x2, (float)y1, (float)z).m_85950_(g, h, i, f).m_5752_();
    }

    public void drawCenteredString(Font font, String text, int x, int y, int color) {
        this.drawString(font, text, x - font.m_92895_(text) / 2, y, color);
    }

    public void drawCenteredString(Font font, Component text, int x, int y, int color) {
        FormattedCharSequence formattedCharSequence = text.m_7532_();
        this.drawString(font, formattedCharSequence, x - font.m_92724_(formattedCharSequence) / 2, y, color);
    }

    public void drawCenteredString(Font font, FormattedCharSequence text, int x, int y, int color) {
        this.drawString(font, text, x - font.m_92724_(text) / 2, y, color);
    }

    public int drawString(Font font, @Nullable String text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(Font font, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        boolean seeThrough = false;
        int i = font.m_92822_(text, (float)x, (float)y, color, dropShadow, this.pose.m_85850_().m_85861_(), (MultiBufferSource)this.bufferSource, seeThrough, 0, 0xF000F0, font.m_92718_());
        this.flushIfUnmanaged();
        return i;
    }

    public int drawString(Font font, FormattedCharSequence text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        boolean seeThrough = false;
        int i = font.m_92733_(text, (float)x, (float)y, color, dropShadow, this.pose.m_85850_().m_85861_(), (MultiBufferSource)this.bufferSource, seeThrough, 0, 0xF000F0);
        this.flushIfUnmanaged();
        return i;
    }

    public int drawString(Font font, Component text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(Font font, Component text, int x, int y, int color, boolean dropShadow) {
        return this.drawString(font, text.m_7532_(), x, y, color, dropShadow);
    }

    public void drawWordWrap(Font font, FormattedText text, int x, int y, int lineWidth, int color) {
        for (FormattedCharSequence formattedCharSequence : font.m_92923_(text, lineWidth)) {
            this.drawString(font, formattedCharSequence, x, y, color, false);
            y += 9;
        }
    }

    public void blit(int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite) {
        this.innerBlit(sprite.m_118413_(), x, x + width, y, y + height, blitOffset, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public void blit(int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.innerBlit(sprite.m_118413_(), x, x + width, y, y + height, blitOffset, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), red, green, blue, alpha);
    }

    public void renderOutline(int x, int y, int width, int height, int color) {
        this.fill(x, y, x + width, y + 1, color);
        this.fill(x, y + height - 1, x + width, y + height, color);
        this.fill(x, y + 1, x + 1, y + height - 1, color);
        this.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, 0, (float)uOffset, vOffset, uWidth, vHeight, 256, 256);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    void blit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    void innerBlit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix4F = this.pose.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4F, (float)x1, (float)y1, (float)blitOffset).m_7421_(minU, minV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x1, (float)y2, (float)blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x2, (float)y2, (float)blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x2, (float)y1, (float)blitOffset).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    void innerBlit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_69478_();
        Matrix4f matrix4F = this.pose.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_85982_(matrix4F, (float)x1, (float)y1, (float)blitOffset).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x1, (float)y2, (float)blitOffset).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x2, (float)y2, (float)blitOffset).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferBuilder.m_85982_(matrix4F, (float)x2, (float)y1, (float)blitOffset).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
    }

    public void blitNineSliced(ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, m, m, m, n, o, p, q);
    }

    public void blitNineSliced(ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, n, m, n, o, p, q, r);
    }

    public void blitNineSliced(ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s, int t) {
        m = Math.min(m, k / 2);
        o = Math.min(o, k / 2);
        n = Math.min(n, l / 2);
        p = Math.min(p, l / 2);
        if (k == q && l == r) {
            this.blit(resourceLocation, i, j, s, t, k, l);
        } else if (l == r) {
            this.blit(resourceLocation, i, j, s, t, m, l);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, l, s + m, t, q - o - m, r);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, l);
        } else if (k == q) {
            this.blit(resourceLocation, i, j, s, t, k, n);
            this.blitRepeating(resourceLocation, i, j + n, k, l - p - n, s, t + n, q, r - p - n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, k, p);
        } else {
            this.blit(resourceLocation, i, j, s, t, m, n);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, n, s + m, t, q - o - m, n);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, m, p);
            this.blitRepeating(resourceLocation, i + m, j + l - p, k - o - m, p, s + m, t + r - p, q - o - m, p);
            this.blit(resourceLocation, i + k - o, j + l - p, s + q - o, t + r - p, o, p);
            this.blitRepeating(resourceLocation, i, j + n, m, l - p - n, s, t + n, m, r - p - n);
            this.blitRepeating(resourceLocation, i + m, j + n, k - o - m, l - p - n, s + m, t + n, q - o - m, r - p - n);
            this.blitRepeating(resourceLocation, i + k - o, j + n, m, l - p - n, s + q - o, t + n, o, r - p - n);
        }
    }

    public void blitRepeating(ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p) {
        int q = i;
        IntIterator intIterator = GuiGraphics.slices(k, o);
        while (intIterator.hasNext()) {
            int r = intIterator.nextInt();
            int s = (o - r) / 2;
            int t = j;
            IntIterator intIterator2 = GuiGraphics.slices(l, p);
            while (intIterator2.hasNext()) {
                int u = intIterator2.nextInt();
                int v = (p - u) / 2;
                this.blit(resourceLocation, q, t, m + s, n + v, r, u);
                t += u;
            }
            q += r;
        }
    }

    private static IntIterator slices(int i, int j) {
        int k = Mth.m_184652_((int)i, (int)j);
        return new Divisor(i, k);
    }

    public void renderItem(ItemStack stack, int x, int y) {
        this.renderItem((LivingEntity)this.minecraft.f_91074_, (Level)this.minecraft.f_91073_, stack, x, y, 0);
    }

    public void renderItem(ItemStack stack, int x, int y, int seed) {
        this.renderItem((LivingEntity)this.minecraft.f_91074_, (Level)this.minecraft.f_91073_, stack, x, y, seed);
    }

    public void renderItem(ItemStack stack, int x, int y, int seed, int guiOffset) {
        this.renderItem((LivingEntity)this.minecraft.f_91074_, (Level)this.minecraft.f_91073_, stack, x, y, seed, guiOffset);
    }

    public void renderFakeItem(ItemStack stack, int x, int y) {
        this.renderItem(null, (Level)this.minecraft.f_91073_, stack, x, y, 0);
    }

    public void renderItem(LivingEntity entity, ItemStack stack, int x, int y, int seed) {
        this.renderItem(entity, entity.f_19853_, stack, x, y, seed);
    }

    private void renderItem(@Nullable LivingEntity entity, @Nullable Level level, ItemStack stack, int x, int y, int seed) {
        this.renderItem(entity, level, stack, x, y, seed, 0);
    }

    private void renderItem(@Nullable LivingEntity entity, @Nullable Level level, ItemStack stack, int x, int y, int seed, int guiOffset) {
        if (!stack.m_41619_()) {
            BakedModel bakedModel = this.minecraft.m_91291_().m_174264_(stack, level, entity, seed);
            this.pose.m_85836_();
            this.pose.m_85837_((double)(x + 8), (double)(y + 8), (double)(150 + (bakedModel.m_7539_() ? guiOffset : 0)));
            try {
                boolean bl;
                this.pose.m_166854_((Matrix4f)new GuiMatrix4f().scaling(1.0f, -1.0f, 1.0f));
                this.pose.m_85841_(16.0f, 16.0f, 16.0f);
                boolean bl2 = bl = !bakedModel.m_7547_();
                if (bl) {
                    Lighting.m_84930_();
                }
                this.minecraft.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GUI, false, this.pose, (MultiBufferSource)this.bufferSource(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
                this.flush();
                if (bl) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable var12) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)var12, (String)"Rendering item");
                CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being rendered");
                crashReportCategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashReportCategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashReportCategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashReportCategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashReport);
            }
            this.pose.m_85849_();
        }
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y) {
        this.renderItemDecorations(font, stack, x, y, null);
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y, @Nullable String text) {
        if (!stack.m_41619_()) {
            LocalPlayer localPlayer;
            float f;
            int l;
            int k;
            this.pose.m_85836_();
            if (stack.m_41613_() != 1 || text != null) {
                String string = text == null ? String.valueOf(stack.m_41613_()) : text;
                this.pose.m_85837_(0.0, 0.0, 200.0);
                this.drawString(font, string, x + 19 - 2 - font.m_92895_(string), y + 6 + 3, 0xFFFFFF, true);
            }
            if (stack.m_150947_()) {
                int i = stack.m_150948_();
                int j = stack.m_150949_();
                k = x + 2;
                l = y + 13;
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + 13, l + 2, -16777216);
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + i, l + 1, j | 0xFF000000);
            }
            float f2 = f = (localPlayer = this.minecraft.f_91074_) == null ? 0.0f : localPlayer.m_36335_().m_41521_(stack.m_41720_(), this.minecraft.m_91296_());
            if (f > 0.0f) {
                k = y + Mth.m_14143_((float)(16.0f * (1.0f - f)));
                l = k + Mth.m_14167_((float)(16.0f * f));
                this.fill(GuiRenderTypes.guiOverlay(), x, k, x + 16, l, Integer.MAX_VALUE);
            }
            this.pose.m_85849_();
        }
    }

    public void renderTooltip(Font font, ItemStack stack, int mouseX, int mouseY) {
        this.renderTooltip(font, DUMMY_SCREEN.m_96555_(stack), stack.m_150921_(), mouseX, mouseY);
    }

    public void renderTooltip(Font font, List<Component> tooltipLines, Optional<TooltipComponent> visualTooltipComponent, int mouseX, int mouseY) {
        List<ClientTooltipComponent> list = tooltipLines.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList());
        visualTooltipComponent.ifPresent(tooltipComponent -> list.add(1, ClientTooltipComponent.m_169950_((TooltipComponent)tooltipComponent)));
        this.renderTooltipInternal(font, list, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(Font font, Component text, int mouseX, int mouseY) {
        this.renderTooltip(font, List.of(text.m_7532_()), mouseX, mouseY);
    }

    public void renderComponentTooltip(Font font, List<Component> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltip(font, Lists.transform(tooltipLines, Component::m_7532_), mouseX, mouseY);
    }

    public void renderTooltip(Font font, List<? extends FormattedCharSequence> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltipInternal(font, tooltipLines.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(Font font, List<FormattedCharSequence> tooltipLines, ClientTooltipPositioner tooltipPositioner, int mouseX, int mouseY) {
        this.renderTooltipInternal(font, tooltipLines.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), mouseX, mouseY, tooltipPositioner);
    }

    private void renderTooltipInternal(Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner tooltipPositioner) {
        if (!components.isEmpty()) {
            ClientTooltipComponent clientTooltipComponent2;
            int r;
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clientTooltipComponent : components) {
                int k = clientTooltipComponent.m_142069_(font);
                if (k > i) {
                    i = k;
                }
                j += clientTooltipComponent.m_142103_();
            }
            int l = i;
            int m = j;
            Vector2ic vector2ic = tooltipPositioner.positionTooltip(this.guiWidth(), this.guiHeight(), mouseX, mouseY, l, m);
            int n = vector2ic.x();
            int o = vector2ic.y();
            this.pose.m_85836_();
            int p = 400;
            this.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground(this, n, o, l, m, 400));
            this.pose.m_85837_(0.0, 0.0, 400.0);
            int q = o;
            for (r = 0; r < components.size(); ++r) {
                clientTooltipComponent2 = components.get(r);
                clientTooltipComponent2.m_142440_(font, n, q, this.pose.m_85850_().m_85861_(), this.bufferSource);
                q += clientTooltipComponent2.m_142103_() + (r == 0 ? 2 : 0);
            }
            q = o;
            for (r = 0; r < components.size(); ++r) {
                clientTooltipComponent2 = components.get(r);
                clientTooltipComponent2.m_183452_(font, n, q, this.pose, Minecraft.m_91087_().m_91291_(), 400);
                q += clientTooltipComponent2.m_142103_() + (r == 0 ? 2 : 0);
            }
            this.pose.m_85849_();
        }
    }

    public void renderComponentHoverEffect(Font font, @Nullable Style style, int mouseX, int mouseY) {
        if (style != null && style.m_131186_() != null) {
            HoverEvent hoverEvent = style.m_131186_();
            HoverEvent.ItemStackInfo itemStackInfo = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
            if (itemStackInfo != null) {
                this.renderTooltip(font, itemStackInfo.m_130898_(), mouseX, mouseY);
            } else {
                HoverEvent.EntityTooltipInfo entityTooltipInfo = (HoverEvent.EntityTooltipInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130833_);
                if (entityTooltipInfo != null) {
                    if (this.minecraft.f_91066_.f_92125_) {
                        this.renderComponentTooltip(font, entityTooltipInfo.m_130884_(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)hoverEvent.m_130823_(HoverEvent.Action.f_130831_);
                    if (component != null) {
                        this.renderTooltip(font, font.m_92923_((FormattedText)component, Math.max(this.guiWidth() / 2, 200)), mouseX, mouseY);
                    }
                }
            }
        }
    }

    public static class ScissorStack {
        private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

        public ScreenRectangle push(ScreenRectangle scissor) {
            ScreenRectangle screenRectangle = this.stack.peekLast();
            if (screenRectangle != null) {
                ScreenRectangle screenRectangle2 = Objects.requireNonNullElse(scissor.intersection(screenRectangle), ScreenRectangle.empty());
                this.stack.addLast(screenRectangle2);
                return screenRectangle2;
            }
            this.stack.addLast(scissor);
            return scissor;
        }

        @Nullable
        public ScreenRectangle pop() {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Scissor stack underflow");
            }
            this.stack.removeLast();
            return this.stack.peekLast();
        }
    }
}

