/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui;

import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.file.FileFilter;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroups;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.screen.RangeSliderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.ChooseFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.video.IVideo;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonStackableOverlayUI {
    public static ContextMenu.ClickableContextMenuEntry<?> addImageResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, ResourceSupplier<ITexture> defaultValue, @NotNull Supplier<ResourceSupplier<ITexture>> targetFieldGetter, @NotNull Consumer<ResourceSupplier<ITexture>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        return NonStackableOverlayUI.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, () -> ResourceChooserScreen.image(null, file -> {}), ResourceSupplier::image, defaultValue, targetFieldGetter, targetFieldSetter, label, addResetOption, FileTypeGroups.IMAGE_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    public static ContextMenu.ClickableContextMenuEntry<?> addAudioResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, ResourceSupplier<IAudio> defaultValue, @NotNull Supplier<ResourceSupplier<IAudio>> targetFieldGetter, @NotNull Consumer<ResourceSupplier<IAudio>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        return NonStackableOverlayUI.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, () -> ResourceChooserScreen.audio(null, file -> {}), ResourceSupplier::audio, defaultValue, targetFieldGetter, targetFieldSetter, label, addResetOption, FileTypeGroups.AUDIO_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    public static ContextMenu.ClickableContextMenuEntry<?> addVideoResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, ResourceSupplier<IVideo> defaultValue, @NotNull Supplier<ResourceSupplier<IVideo>> targetFieldGetter, @NotNull Consumer<ResourceSupplier<IVideo>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        return NonStackableOverlayUI.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, () -> ResourceChooserScreen.video(null, file -> {}), ResourceSupplier::video, defaultValue, targetFieldGetter, targetFieldSetter, label, addResetOption, FileTypeGroups.VIDEO_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    public static ContextMenu.ClickableContextMenuEntry<?> addTextResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, ResourceSupplier<IText> defaultValue, @NotNull Supplier<ResourceSupplier<IText>> targetFieldGetter, @NotNull Consumer<ResourceSupplier<IText>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        return NonStackableOverlayUI.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, () -> ResourceChooserScreen.text(null, file -> {}), ResourceSupplier::text, defaultValue, targetFieldGetter, targetFieldSetter, label, addResetOption, FileTypeGroups.TEXT_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    public static <R extends Resource, F extends FileType<R>> ContextMenu.ClickableContextMenuEntry<?> addGenericResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Supplier<ResourceChooserScreen<R, F>> resourceChooserScreenBuilder, @NotNull ConsumingSupplier<String, ResourceSupplier<R>> resourceSupplierBuilder, ResourceSupplier<R> defaultValue, @NotNull Supplier<ResourceSupplier<R>> targetFieldGetter, @NotNull Consumer<ResourceSupplier<R>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileTypeGroup<F> fileTypes, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ContextMenu subMenu = new ContextMenu();
        subMenu.addClickableEntry("choose_file", (Component)Components.translatable("fancymenu.ui.resources.choose", new Object[0]), (menu, entry) -> {
            Screen current = Minecraft.m_91087_().f_91080_;
            ResourceSupplier supplier = (ResourceSupplier)targetFieldGetter.get();
            String preSelectedSource = supplier != null ? supplier.getSourceWithPrefix() : null;
            ResourceChooserScreen chooserScreen = (ResourceChooserScreen)resourceChooserScreenBuilder.get();
            chooserScreen.setFileFilter(fileFilter);
            chooserScreen.setAllowedFileTypes(fileTypes);
            chooserScreen.setSource(preSelectedSource, false);
            chooserScreen.setLocationSourceAllowed(allowLocation);
            chooserScreen.setLocalSourceAllowed(allowLocal);
            chooserScreen.setWebSourceAllowed(allowWeb);
            chooserScreen.setResourceSourceCallback(source -> {
                if (source != null) {
                    targetFieldSetter.accept((ResourceSupplier)resourceSupplierBuilder.get((String)source));
                }
                Minecraft.m_91087_().m_91152_(current);
            });
            Minecraft.m_91087_().m_91152_((Screen)chooserScreen);
        }).setStackable(false);
        if (addResetOption) {
            subMenu.addClickableEntry("reset_to_default", (Component)Components.translatable("fancymenu.ui.resources.reset", new Object[0]), (menu, entry) -> targetFieldSetter.accept(defaultValue)).setStackable(false);
        }
        Supplier<Component> currentValueDisplayLabelSupplier = () -> {
            MutableComponent valueComponent;
            Object val;
            ResourceSupplier supplier = (ResourceSupplier)targetFieldGetter.get();
            Object object = val = supplier != null ? supplier.getSourceWithoutPrefix() : null;
            if (val == null) {
                valueComponent = Components.literal("---").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            } else {
                if (Minecraft.m_91087_().f_91062_.m_92895_((String)(val = GameDirectoryUtils.getPathWithoutGameDirectory((String)val))) > 150) {
                    val = new StringBuilder((String)val).reverse().toString();
                    val = Minecraft.m_91087_().f_91062_.m_92834_((String)val, 150);
                    val = new StringBuilder((String)val).reverse().toString();
                    val = ".." + (String)val;
                }
                valueComponent = Components.literal((String)val).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            }
            return Components.translatable("fancymenu.ui.resources.current", valueComponent);
        };
        subMenu.addSeparatorEntry("separator_before_current_value_display");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("current_value_display", (Component)Components.empty(), (menu, entry) -> {}).setLabelSupplier((menu, entry) -> (Component)currentValueDisplayLabelSupplier.get())).setClickSoundEnabled(false)).setIcon(ContextMenu.IconFactory.getIcon("info"));
        return (ContextMenu.ClickableContextMenuEntry)addTo.addSubMenuEntry(entryIdentifier, label, subMenu).setStackable(true);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addFileChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<String> getter, @NotNull Consumer<String> setter, boolean addResetOption, String defaultValue, @Nullable FileFilter fileFilter) {
        return NonStackableOverlayUI.addFileChooserContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, fileFilter, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addFileChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<String> getter, @NotNull Consumer<String> setter, boolean addResetOption, String defaultValue, @Nullable FileFilter fileFilter, @Nullable FileTypeGroup<?> fileTypes) {
        return NonStackableOverlayUI.addFileChooserContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, fileFilter, fileTypes, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addFileChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<String> getter, @NotNull Consumer<String> setter, boolean addResetOption, String defaultValue, @Nullable FileFilter fileFilter, @Nullable FileTypeGroup<?> fileTypes, @Nullable BiConsumer<Screen, File> onCloseFileChooser) {
        ContextMenu subMenu = new ContextMenu();
        subMenu.addClickableEntry("choose_file", (Component)Components.translatable("fancymenu.ui.filechooser.choose.file", new Object[0]), (menu, entry) -> {
            File startDir = LayoutHandler.ASSETS_DIR;
            String path = (String)getter.get();
            if (path != null && (startDir = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path)).getParentFile()) == null) {
                startDir = LayoutHandler.ASSETS_DIR;
            }
            Screen current = Minecraft.m_91087_().f_91080_;
            ChooseFileScreen fileChooser = new ChooseFileScreen(LayoutHandler.ASSETS_DIR, startDir, call -> {
                if (call != null) {
                    setter.accept(call.getPath());
                }
                menu.closeMenu();
                if (onCloseFileChooser != null) {
                    onCloseFileChooser.accept(current, (File)call);
                } else {
                    Minecraft.m_91087_().m_91152_(current);
                }
            });
            fileChooser.setVisibleDirectoryLevelsAboveRoot(2);
            fileChooser.setFileFilter(fileFilter);
            fileChooser.setFileTypes(fileTypes);
            Minecraft.m_91087_().m_91152_((Screen)fileChooser);
        });
        if (addResetOption) {
            subMenu.addClickableEntry("reset_to_default", (Component)Components.translatable("fancymenu.editor.filechooser.reset", new Object[0]), (menu, entry) -> setter.accept(defaultValue));
        }
        Supplier<Component> currentValueDisplayLabelSupplier = () -> {
            MutableComponent valueComponent;
            Object val = (String)getter.get();
            if (val == null) {
                valueComponent = Components.literal("---").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            } else {
                if (Minecraft.m_91087_().f_91062_.m_92895_((String)(val = GameDirectoryUtils.getPathWithoutGameDirectory((String)val))) > 150) {
                    val = new StringBuilder((String)val).reverse().toString();
                    val = Minecraft.m_91087_().f_91062_.m_92834_((String)val, 150);
                    val = new StringBuilder((String)val).reverse().toString();
                    val = ".." + (String)val;
                }
                valueComponent = Components.literal((String)val).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            }
            return Components.translatable("fancymenu.context_menu.entries.choose_or_set.current", valueComponent);
        };
        subMenu.addSeparatorEntry("separator_before_current_value_display");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("current_value_display", (Component)Components.empty(), (menu, entry) -> {}).setLabelSupplier((menu, entry) -> (Component)currentValueDisplayLabelSupplier.get())).setClickSoundEnabled(false)).setChangeBackgroundColorOnHover(false)).setIcon(ContextMenu.IconFactory.getIcon("info"));
        return addTo.addSubMenuEntry(entryIdentifier, label, subMenu);
    }

    @NotNull
    public static <T> ContextMenu.ClickableContextMenuEntry<?> addGenericInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<T> getter, @NotNull Consumer<T> setter, boolean addResetOption, T defaultValue, @NotNull Consumer<Consumer<T>> inputLogic) {
        ContextMenu subMenu = new ContextMenu();
        subMenu.addClickableEntry("input_value", (Component)Component.m_237115_((String)"fancymenu.common_components.set"), (menu, entry) -> {
            menu.closeMenu();
            inputLogic.accept(setter);
        });
        if (addResetOption) {
            subMenu.addClickableEntry("reset_to_default", (Component)Component.m_237115_((String)"fancymenu.common_components.reset"), (menu, entry) -> setter.accept(defaultValue));
        }
        Supplier<Component> currentValueDisplayLabelSupplier = () -> {
            MutableComponent valueComponent;
            Object val = getter.get();
            if (val == null) {
                valueComponent = Components.literal("---").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            } else {
                Object valString = val.toString();
                if (Minecraft.m_91087_().f_91062_.m_92895_((String)valString) > 150) {
                    valString = new StringBuilder((String)valString).reverse().toString();
                    valString = Minecraft.m_91087_().f_91062_.m_92834_((String)valString, 150);
                    valString = new StringBuilder((String)valString).reverse().toString();
                    valString = ".." + (String)valString;
                }
                valueComponent = Components.literal((String)valString).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            }
            return Components.translatable("fancymenu.context_menu.entries.choose_or_set.current", valueComponent);
        };
        subMenu.addSeparatorEntry("separator_before_current_value_display");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("current_value_display", (Component)Components.empty(), (menu, entry) -> {}).setLabelSupplier((menu, entry) -> (Component)currentValueDisplayLabelSupplier.get())).setClickSoundEnabled(false)).setChangeBackgroundColorOnHover(false)).setIcon(ContextMenu.IconFactory.getIcon("info"));
        return addTo.addSubMenuEntry(entryIdentifier, label, subMenu);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addRangeSliderInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Double> getter, @NotNull Consumer<Double> setter, boolean addResetOption, double defaultValue, double minSliderValue, double maxSliderValue, @NotNull ConsumingSupplier<Double, Component> sliderLabelSupplier) {
        return NonStackableOverlayUI.addGenericInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, valueSetter -> {
            Screen current = Minecraft.m_91087_().f_91080_;
            Minecraft.m_91087_().m_91152_((Screen)new RangeSliderScreen(label, minSliderValue, maxSliderValue, Objects.requireNonNullElse((Double)getter.get(), 0.0), sliderLabelSupplier, aDouble -> {
                if (aDouble != null) {
                    valueSetter.accept(aDouble);
                }
                Minecraft.m_91087_().m_91152_(current);
            }));
        });
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<String> getter, @NotNull Consumer<String> setter, boolean addResetOption, String defaultValue, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return NonStackableOverlayUI.addInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, inputCharacterFilter, multiLineInput, allowPlaceholders, textValidator, textValidatorUserFeedback, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<String> getter, @NotNull Consumer<String> setter, boolean addResetOption, String defaultValue, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback, @Nullable BiConsumer<Screen, String> onCloseEditor) {
        return NonStackableOverlayUI.addGenericInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, valueSetter -> {
            Screen inputScreen;
            Screen current = Minecraft.m_91087_().f_91080_;
            if (!multiLineInput && !allowPlaceholders) {
                TextInputScreen s = TextInputScreen.build(label, inputCharacterFilter, call -> {
                    if (call != null) {
                        valueSetter.accept(call);
                    }
                    if (onCloseEditor != null) {
                        onCloseEditor.accept(current, (String)call);
                    } else {
                        Minecraft.m_91087_().m_91152_(current);
                    }
                });
                if (textValidator != null) {
                    s.setTextValidator(consumes -> {
                        if (textValidatorUserFeedback != null) {
                            consumes.setTextValidatorUserFeedback((Tooltip)textValidatorUserFeedback.get(consumes.getText()));
                        }
                        return (Boolean)textValidator.get(consumes.getText());
                    });
                }
                s.setText((String)getter.get());
                inputScreen = s;
            } else {
                TextEditorScreen s = new TextEditorScreen(label, inputCharacterFilter != null ? inputCharacterFilter.convertToLegacyFilter() : null, call -> {
                    if (call != null) {
                        valueSetter.accept(call);
                    }
                    if (onCloseEditor != null) {
                        onCloseEditor.accept(current, (String)call);
                    } else {
                        Minecraft.m_91087_().m_91152_(current);
                    }
                });
                if (textValidator != null) {
                    s.setTextValidator(consumes -> {
                        if (textValidatorUserFeedback != null) {
                            consumes.setTextValidatorUserFeedback((Tooltip)textValidatorUserFeedback.get(consumes.getText()));
                        }
                        return (Boolean)textValidator.get(consumes.getText());
                    });
                }
                s.setMultilineMode(multiLineInput);
                s.setPlaceholdersAllowed(allowPlaceholders);
                s.setText((String)getter.get());
                inputScreen = s;
            }
            Minecraft.m_91087_().m_91152_(inputScreen);
        });
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addIntegerInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Integer> getter, @NotNull Consumer<Integer> setter, boolean addResetOption, int defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return NonStackableOverlayUI.addIntegerInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, textValidator, textValidatorUserFeedback, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addIntegerInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Integer> getter, @NotNull Consumer<Integer> setter, boolean addResetOption, int defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback, @Nullable BiConsumer<Screen, String> onCloseEditor) {
        ConsumingSupplier<String, Boolean> defaultIntegerValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && MathUtils.isInteger((String)consumes);
        return NonStackableOverlayUI.addInputContextMenuEntryTo(addTo, entryIdentifier, label, () -> String.valueOf(Objects.requireNonNullElse((Serializable)getter.get(), "")), s -> {
            if (MathUtils.isInteger((String)s)) {
                setter.accept(Integer.valueOf(s));
            }
        }, addResetOption, "" + defaultValue, CharacterFilter.buildIntegerFiler(), false, false, textValidator != null ? textValidator : defaultIntegerValidator, textValidatorUserFeedback, onCloseEditor);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addDoubleInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Double> getter, @NotNull Consumer<Double> setter, boolean addResetOption, double defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return NonStackableOverlayUI.addDoubleInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, textValidator, textValidatorUserFeedback, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addDoubleInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Double> getter, @NotNull Consumer<Double> setter, boolean addResetOption, double defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback, @Nullable BiConsumer<Screen, String> onCloseEditor) {
        ConsumingSupplier<String, Boolean> defaultDoubleValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && MathUtils.isDouble((String)consumes);
        return NonStackableOverlayUI.addInputContextMenuEntryTo(addTo, entryIdentifier, label, () -> String.valueOf(Objects.requireNonNullElse((Serializable)getter.get(), "")), s -> {
            if (MathUtils.isDouble((String)s)) {
                setter.accept(Double.valueOf(s));
            }
        }, addResetOption, "" + defaultValue, CharacterFilter.buildDecimalFiler(), false, false, textValidator != null ? textValidator : defaultDoubleValidator, textValidatorUserFeedback, onCloseEditor);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addFloatInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Float> getter, @NotNull Consumer<Float> setter, boolean addResetOption, float defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return NonStackableOverlayUI.addFloatInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, textValidator, textValidatorUserFeedback, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addFloatInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Float> getter, @NotNull Consumer<Float> setter, boolean addResetOption, float defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback, @Nullable BiConsumer<Screen, String> onCloseEditor) {
        ConsumingSupplier<String, Boolean> defaultFloatValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && MathUtils.isFloat((String)consumes);
        return NonStackableOverlayUI.addInputContextMenuEntryTo(addTo, entryIdentifier, label, () -> String.valueOf(Objects.requireNonNullElse((Serializable)getter.get(), "")), s -> {
            if (MathUtils.isFloat((String)s)) {
                setter.accept(Float.valueOf(s));
            }
        }, addResetOption, "" + defaultValue, CharacterFilter.buildDecimalFiler(), false, false, textValidator != null ? textValidator : defaultFloatValidator, textValidatorUserFeedback, onCloseEditor);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addLongInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Long> getter, @NotNull Consumer<Long> setter, boolean addResetOption, long defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return NonStackableOverlayUI.addLongInputContextMenuEntryTo(addTo, entryIdentifier, label, getter, setter, addResetOption, defaultValue, textValidator, textValidatorUserFeedback, null);
    }

    @NotNull
    public static ContextMenu.ClickableContextMenuEntry<?> addLongInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Component label, @NotNull Supplier<Long> getter, @NotNull Consumer<Long> setter, boolean addResetOption, long defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback, @Nullable BiConsumer<Screen, String> onCloseEditor) {
        ConsumingSupplier<String, Boolean> defaultLongValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && MathUtils.isLong((String)consumes);
        return NonStackableOverlayUI.addInputContextMenuEntryTo(addTo, entryIdentifier, label, () -> String.valueOf(Objects.requireNonNullElse((Serializable)getter.get(), "")), s -> {
            if (MathUtils.isLong((String)s)) {
                setter.accept(Long.valueOf(s));
            }
        }, addResetOption, "" + defaultValue, CharacterFilter.buildIntegerFiler(), false, false, textValidator != null ? textValidator : defaultLongValidator, textValidatorUserFeedback, onCloseEditor);
    }
}

