/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInputScreen
extends Screen {
    @NotNull
    protected Consumer<String> callback;
    protected ExtendedEditBox input;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ConsumingSupplier<TextInputScreen, Boolean> textValidator = null;
    protected Tooltip textValidatorFeedbackTooltip = null;

    @NotNull
    public static TextInputScreen build(@NotNull Component title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        return new TextInputScreen(title, filter, callback);
    }

    public TextInputScreen(@NotNull Component title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        super(title);
        this.callback = callback;
        this.input = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Components.empty());
        this.input.m_94199_(10000);
        this.input.setCharacterFilter(filter);
        UIBase.applyDefaultWidgetSkinTo(this.input);
    }

    protected void m_7856_() {
        this.m_7787_((GuiEventListener)this.input);
        this.m_7522_((GuiEventListener)this.input);
        this.cancelButton = new ExtendedButton(0, 0, 100, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> this.callback.accept(null));
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton = new ExtendedButton(0, 0, 100, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> {
            if (this.isTextValid()) {
                this.callback.accept(this.input.m_94155_());
            }
        });
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void m_86600_() {
        this.input.m_94120_();
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextInputScreen.m_93172_((PoseStack)pose, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)UIBase.getUIColorTheme().screen_background_color.getColorInt());
        RenderSystem.m_69478_();
        MutableComponent t = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        int titleWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)t);
        this.f_96547_.m_92889_(pose, (Component)t, (float)(this.f_96543_ / 2 - titleWidth / 2), (float)(this.f_96544_ / 2 - 30), UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
        this.input.m_94214_(this.f_96543_ / 2 - this.input.m_5711_() / 2);
        this.input.f_93621_ = this.f_96544_ / 2 - this.input.m_93694_() / 2;
        this.input.m_6305_(pose, mouseX, mouseY, partial);
        this.cancelButton.f_93620_ = this.f_96543_ / 2 - 5 - this.cancelButton.m_5711_();
        this.cancelButton.f_93621_ = this.f_96544_ - 40;
        this.cancelButton.m_6305_(pose, mouseX, mouseY, partial);
        this.doneButton.f_93623_ = this.isTextValid();
        if (this.textValidatorFeedbackTooltip != null) {
            this.textValidatorFeedbackTooltip.setDefaultStyle();
        }
        this.doneButton.setTooltip(this.textValidatorFeedbackTooltip);
        this.doneButton.f_93620_ = this.f_96543_ / 2 + 5;
        this.doneButton.f_93621_ = this.f_96544_ - 40;
        this.doneButton.m_6305_(pose, mouseX, mouseY, partial);
    }

    public boolean m_7933_(int button, int p_96553_, int p_96554_) {
        if (button == 257 && this.isTextValid()) {
            this.callback.accept(this.input.m_94155_());
            return true;
        }
        return super.m_7933_(button, p_96553_, p_96554_);
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    public TextInputScreen setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        this.input.m_94144_(text);
        return this;
    }

    public String getText() {
        return this.input.m_94155_();
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public TextInputScreen setTextValidator(@Nullable ConsumingSupplier<TextInputScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public TextInputScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }
}

