/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizerHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScrollScreenNormalizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ScrollableScreenBlacklistRule> SCROLLABLE_SCREEN_BLACKLIST = new ArrayList<ScrollableScreenBlacklistRule>();

    @NotNull
    public static Screen normalizeScrollableScreen(@NotNull Screen screen) {
        if (ScrollScreenNormalizer.isBlacklisted(screen)) {
            return screen;
        }
        if (!ScrollScreenNormalizerHandler.shouldNormalize(screen)) {
            return screen;
        }
        if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) {
            return screen;
        }
        List<AbstractWidget> extracted = ScrollScreenNormalizer.extractAllWidgetsFromScrollListsOfScreen(screen);
        IMixinScreen accessor = (IMixinScreen)screen;
        ScrollScreenNormalizer.extractAllScrollListsOfScreen(screen).forEach(scroll -> {
            scroll.m_93437_(1000000, 1000000, 0, 0);
            accessor.getChildrenFancyMenu().remove(scroll);
            accessor.getNarratablesFancyMenu().remove(scroll);
            accessor.getRenderablesFancyMenu().remove(scroll);
        });
        extracted.forEach(widget -> {
            accessor.getChildrenFancyMenu().remove(widget);
            accessor.getNarratablesFancyMenu().remove(widget);
            accessor.getRenderablesFancyMenu().remove(widget);
        });
        int pos = 50;
        HashMap<Object, Integer> ids = new HashMap<Object, Integer>();
        for (AbstractWidget widget2 : extracted) {
            widget2.f_93620_ = pos;
            widget2.f_93621_ = pos++;
            if (screen instanceof OptionsSubScreen && widget2 instanceof UniqueWidget) {
                UniqueWidget w = (UniqueWidget)widget2;
                StringBuilder id = new StringBuilder("options");
                ScrollScreenNormalizer.buildId(widget2.m_6035_().m_214077_(), id);
                Object idString = id.toString();
                if (((String)idString).equals("options")) {
                    idString = (String)idString + "_generic";
                }
                if (ids.containsKey(idString)) {
                    int count = (Integer)ids.get(idString);
                    ids.put(idString, ++count);
                    idString = (String)idString + "_" + count;
                } else {
                    ids.put(idString, 0);
                }
                w.setWidgetIdentifierFancyMenu((String)idString);
            }
            accessor.getChildrenFancyMenu().add((GuiEventListener)widget2);
            accessor.getRenderablesFancyMenu().add((Widget)widget2);
            accessor.getNarratablesFancyMenu().add((NarratableEntry)widget2);
        }
        return screen;
    }

    @NotNull
    private static StringBuilder buildId(@NotNull ComponentContents contents, @NotNull StringBuilder builder) {
        if (contents instanceof TranslatableContents) {
            MutableComponent c;
            ComponentContents componentContents;
            Object object;
            TranslatableContents t = (TranslatableContents)contents;
            builder.append("_");
            Object[] args = t.m_237523_();
            if (args.length > 0 && (object = args[0]) instanceof MutableComponent && (componentContents = (c = (MutableComponent)object).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents t2 = (TranslatableContents)componentContents;
                builder.append(t2.m_237508_());
                return builder;
            }
            builder.append(t.m_237508_());
        }
        return builder;
    }

    public static boolean isBlacklisted(@NotNull Screen screen) {
        for (ScrollableScreenBlacklistRule e : SCROLLABLE_SCREEN_BLACKLIST) {
            if (!e.isBlacklisted(screen)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<AbstractSelectionList<?>> extractAllScrollListsOfScreen(@NotNull Screen screen) {
        ArrayList list = new ArrayList();
        screen.m_6702_().forEach(o -> {
            if (o instanceof AbstractSelectionList) {
                AbstractSelectionList l = (AbstractSelectionList)o;
                list.add(l);
            }
        });
        return list;
    }

    @NotNull
    public static List<AbstractWidget> extractAllWidgetsFromScrollListsOfScreen(@NotNull Screen screen) {
        ArrayList<AbstractWidget> list = new ArrayList<AbstractWidget>();
        for (GuiEventListener o : ((IMixinScreen)screen).getChildrenFancyMenu()) {
            if (!(o instanceof AbstractSelectionList)) continue;
            AbstractSelectionList sel = (AbstractSelectionList)o;
            sel.m_6702_().forEach(entry -> {
                if (entry instanceof ContainerEventHandler) {
                    ContainerEventHandler h = (ContainerEventHandler)entry;
                    ScrollScreenNormalizer.extractWidgetsRecursively(h, list);
                }
            });
        }
        return list;
    }

    private static void extractWidgetsRecursively(@NotNull ContainerEventHandler container, @NotNull List<AbstractWidget> list) {
        container.m_6702_().forEach(child -> {
            if (child instanceof ContainerEventHandler) {
                ContainerEventHandler childContainer = (ContainerEventHandler)child;
                ScrollScreenNormalizer.extractWidgetsRecursively(childContainer, list);
            } else if (child instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)child;
                list.add(widget);
            }
        });
    }

    public static void addScrollableScreenBlacklistRule(@NotNull ScrollableScreenBlacklistRule rule) {
        SCROLLABLE_SCREEN_BLACKLIST.add(rule);
    }

    static {
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof SelectWorldScreen);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof JoinMultiplayerScreen);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof PackSelectionScreen);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof CustomGuiBaseScreen);
    }

    @FunctionalInterface
    public static interface ScrollableScreenBlacklistRule {
        public boolean isBlacklisted(@NotNull Screen var1);
    }
}

