/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.gui.Axis;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.QuaternionUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MinecraftSplashRenderer {
    public static final int WIDTH_OFFSET = 123;
    public static final int HEIGHT_OFFSET = 69;
    private static MinecraftSplashRenderer defaultInstance = null;
    private static MinecraftSplashRenderer fallbackInstance = new MinecraftSplashRenderer("ERROR");
    private final String splash;

    public MinecraftSplashRenderer(String splash) {
        this.splash = splash;
    }

    public int getDefaultPositionX(int screenWidth) {
        return (int)((float)screenWidth / 2.0f + 123.0f);
    }

    public int getDefaultPositionY() {
        return 69;
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, Font font, int color) {
        guiGraphics.pose().m_85836_();
        guiGraphics.pose().m_85837_((double)((float)screenWidth / 2.0f + 123.0f), 69.0, 0.0);
        guiGraphics.pose().m_85845_(QuaternionUtils.toMojangQuaternion(Axis.ZP.rotationDegrees(-20.0f)));
        float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.m_92895_(this.splash) + 32);
        guiGraphics.pose().m_85841_(f, f, f);
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 0xFFFF00 | color);
        guiGraphics.pose().m_85849_();
    }

    public void renderAt(GuiGraphics guiGraphics, int x, int y, Font font, int color) {
        guiGraphics.pose().m_85836_();
        guiGraphics.pose().m_85837_((double)x, (double)y, 0.0);
        guiGraphics.pose().m_85845_(QuaternionUtils.toMojangQuaternion(Axis.ZP.rotationDegrees(-20.0f)));
        float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.m_92895_(this.splash) + 32);
        guiGraphics.pose().m_85841_(f, f, f);
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 0xFFFF00 | color);
        guiGraphics.pose().m_85849_();
    }

    public String getSplash() {
        return this.splash;
    }

    @NotNull
    public static MinecraftSplashRenderer getDefaultInstance() {
        String vanilla = Minecraft.m_91087_().m_91310_().m_118867_();
        if (vanilla != null) {
            if (defaultInstance == null) {
                defaultInstance = new MinecraftSplashRenderer(vanilla);
            }
            return defaultInstance;
        }
        return fallbackInstance;
    }
}

