/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.widget.ModernAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends ModernAbstractWidget
implements UniqueWidget,
NavigatableWidget,
FancyMenuWidget {
    @Nullable
    protected String widgetIdentifier;
    @NotNull
    protected TextAlignment alignment = TextAlignment.LEFT;
    @NotNull
    protected DrawableColor baseColor = DrawableColor.WHITE;
    protected boolean shadow = true;
    @NotNull
    protected Font font;
    protected float scale = 1.0f;

    @NotNull
    public static TextWidget empty(int x, int y, int width) {
        return new TextWidget(x, y, width, 9, Minecraft.m_91087_().f_91062_, (Component)Component.m_237119_());
    }

    @NotNull
    public static TextWidget of(@NotNull Component text, int x, int y, int width) {
        return new TextWidget(x, y, width, 9, Minecraft.m_91087_().f_91062_, text);
    }

    @NotNull
    public static TextWidget of(@NotNull String text, int x, int y, int width) {
        return TextWidget.of((Component)Component.m_237113_((String)text), x, y, width);
    }

    public TextWidget(int x, int y, int width, int height, @NotNull Font font, @NotNull Component text) {
        super(x, y, width, height, text);
        this.font = font;
        this.updateIntrinsicSize();
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        double drawX = this.getRenderX();
        double drawY = this.getRenderY();
        float currentScale = this.scale;
        RenderingUtils.resetShaderColor(graphics);
        graphics.pose().m_85836_();
        if (currentScale != 1.0f) {
            graphics.pose().m_85841_(currentScale, currentScale, 1.0f);
            drawX /= (double)currentScale;
            drawY /= (double)currentScale;
        }
        graphics.drawString(this.font, this.m_6035_(), Mth.m_14107_((double)drawX), Mth.m_14107_((double)drawY), this.baseColor.getColorInt(), this.shadow);
        graphics.pose().m_85849_();
        RenderingUtils.resetShaderColor(graphics);
    }

    public int getTextWidth() {
        return Mth.m_14165_((double)this.getScaledTextWidth());
    }

    public double getScaledTextWidth() {
        return (float)this.font.m_92724_(this.m_6035_().m_7532_()) * this.scale;
    }

    public double getScaledTextHeight() {
        Objects.requireNonNull(this.font);
        return 9.0f * this.scale;
    }

    public double getRenderX() {
        double textWidth = this.getScaledTextWidth();
        double x = this.getX();
        if (this.alignment == TextAlignment.CENTER) {
            x = (double)this.getX() + (double)this.m_5711_() / 2.0 - textWidth / 2.0;
        } else if (this.alignment == TextAlignment.RIGHT) {
            x = (double)(this.getX() + this.m_5711_()) - textWidth;
        }
        return x;
    }

    public double getRenderY() {
        return this.getY();
    }

    public float getScale() {
        return this.scale;
    }

    public TextWidget setScale(float scale) {
        this.scale = Math.max(1.0E-4f, scale);
        this.updateIntrinsicSize();
        return this;
    }

    @NotNull
    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    public TextWidget setTextAlignment(@NotNull TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        return this.baseColor;
    }

    public TextWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColor = baseColor;
        return this;
    }

    public boolean isShadowEnabled() {
        return this.shadow;
    }

    public TextWidget setShadowEnabled(boolean enabled) {
        this.shadow = enabled;
        return this;
    }

    @NotNull
    public Font getFont() {
        return this.font;
    }

    public TextWidget setFont(@NotNull Font font) {
        this.font = font;
        this.updateIntrinsicSize();
        return this;
    }

    public TextWidget centerWidget(@NotNull Screen parent) {
        this.f_93620_ = parent.f_96543_ / 2 - this.m_5711_() / 2;
        return this;
    }

    public boolean isTextHovered(double mouseX, double mouseY) {
        double x = this.getRenderX();
        double y = this.getRenderY();
        double width = this.getScaledTextWidth();
        double height = this.getScaledTextHeight();
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    @Nullable
    public Style getStyleAtMouseX(double mouseX) {
        double left = this.getRenderX();
        double right = left + this.getScaledTextWidth();
        if (mouseX < left || mouseX > right) {
            return null;
        }
        float safeScale = Math.max(1.0E-4f, this.scale);
        double relative = (mouseX - left) / (double)safeScale;
        return this.font.m_92865_().m_92386_((FormattedText)this.m_6035_(), Mth.m_14107_((double)relative));
    }

    @Override
    public TextWidget setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.widgetIdentifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.widgetIdentifier;
    }

    public void m_142291_(@NotNull NarrationElementOutput var1) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("TextWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("TextWidgets are not navigatable!");
    }

    public void m_7435_(@NotNull SoundManager $$0) {
    }

    protected void updateIntrinsicSize() {
        Objects.requireNonNull(this.font);
        this.f_93619_ = Math.max(1, Mth.m_14167_((float)(9.0f * this.scale)));
    }

    public static enum TextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

