/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.editbox;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinCommandSuggestions;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSuggestionsList;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditBoxSuggestions
extends CommandSuggestions {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    protected static final Style UNPARSED_STYLE = Style.f_131099_.m_131140_(ChatFormatting.RED);
    protected static final Style LITERAL_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    protected static final List<Style> ARGUMENT_STYLES = (List)Stream.of(ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.f_131099_).m_131140_(arg_0)).collect(ImmutableList.toImmutableList());
    protected final Minecraft minecraft;
    protected final Screen screen;
    protected final EditBox input;
    protected final Font font;
    protected final boolean commandsOnly;
    protected final boolean onlyShowIfCursorPastError;
    protected final int lineStartOffset;
    protected final int suggestionLineLimit;
    protected final boolean anchorToBottom;
    protected final List<String> customSuggestionsList = new ArrayList<String>();
    protected boolean onlyCustomSuggestions = false;
    protected boolean allowRenderUsage = true;
    @NotNull
    protected SuggestionsRenderPosition renderPosition = SuggestionsRenderPosition.VANILLA;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor normalTextColor = DrawableColor.of(new Color(-5592406));
    protected DrawableColor selectedTextColor = DrawableColor.of(new Color(-256));
    protected boolean textShadow = true;
    protected boolean autoSuggestions = true;

    @NotNull
    public static EditBoxSuggestions createWithCustomSuggestions(@NotNull Screen screen, @NotNull EditBox editBox, @NotNull SuggestionsRenderPosition renderPosition, @NotNull List<String> suggestions) {
        EditBoxSuggestions variableNameSuggestions = new EditBoxSuggestions(Minecraft.m_91087_(), screen, editBox, Minecraft.m_91087_().f_91062_, false, true, 0, 7, false);
        variableNameSuggestions.m_93922_(true);
        variableNameSuggestions.enableOnlyCustomSuggestionsMode(true);
        variableNameSuggestions.setSuggestionsRenderPosition(renderPosition);
        variableNameSuggestions.setAllowRenderUsage(false);
        variableNameSuggestions.setCustomSuggestions(suggestions);
        variableNameSuggestions.m_93881_();
        return variableNameSuggestions;
    }

    public EditBoxSuggestions(@NotNull Minecraft mc, @NotNull Screen parentScreen, @NotNull EditBox targetEditBox, @NotNull Font font, boolean commandsOnly, boolean onlyShowIfCursorPastError, int lineStartOffset, int suggestionLineLimit, boolean anchorToBottom) {
        super(mc, parentScreen, targetEditBox, font, commandsOnly, onlyShowIfCursorPastError, lineStartOffset, suggestionLineLimit, anchorToBottom, Integer.MIN_VALUE);
        this.minecraft = mc;
        this.screen = parentScreen;
        this.input = targetEditBox;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.onlyShowIfCursorPastError = onlyShowIfCursorPastError;
        this.lineStartOffset = lineStartOffset;
        this.suggestionLineLimit = suggestionLineLimit;
        this.anchorToBottom = anchorToBottom;
    }

    public void m_93900_(@NotNull PoseStack pose, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> cachedUsage = null;
        if (!this.isAllowRenderUsage()) {
            cachedUsage = new ArrayList<FormattedCharSequence>(this.getAccessor().getCommandUsageFancyMenu());
            this.getAccessor().getCommandUsageFancyMenu().clear();
        }
        if (!this.input.m_93696_()) {
            this.setSuggestions(null);
        }
        super.m_93900_(pose, mouseX, mouseY);
        if (cachedUsage != null) {
            this.getAccessor().getCommandUsageFancyMenu().addAll(cachedUsage);
        }
    }

    public void m_93881_() {
        boolean treatAsCommand;
        boolean isReaderCursorAtSlash;
        String editBoxValue = this.input.m_94155_();
        if (this.getCurrentParse() != null && !this.getCurrentParse().getReader().getString().equals(editBoxValue)) {
            this.setCurrentParse(null);
        }
        if (!this.isKeepSuggestions()) {
            this.input.m_94167_(null);
            this.setSuggestions(null);
        }
        this.getCommandUsage().clear();
        StringReader valueReader = new StringReader(editBoxValue);
        boolean bl = isReaderCursorAtSlash = valueReader.canRead() && valueReader.peek() == '/';
        if (isReaderCursorAtSlash) {
            valueReader.skip();
        }
        boolean bl2 = treatAsCommand = this.commandsOnly || isReaderCursorAtSlash;
        if (this.onlyCustomSuggestions) {
            treatAsCommand = false;
        }
        int editBoxCursorPos = this.input.m_94207_();
        if (treatAsCommand) {
            if (this.minecraft.f_91074_ != null) {
                int readerCursorPos;
                CommandDispatcher commands = this.minecraft.f_91074_.f_108617_.m_105146_();
                if (this.getCurrentParse() == null) {
                    this.setCurrentParse((ParseResults<SharedSuggestionProvider>)commands.parse(valueReader, (Object)this.minecraft.f_91074_.f_108617_.m_105137_()));
                }
                int n = readerCursorPos = this.onlyShowIfCursorPastError ? valueReader.getCursor() : 1;
                if (!(editBoxCursorPos < readerCursorPos || this.getSuggestions() != null && this.isKeepSuggestions())) {
                    this.setPendingSuggestions(commands.getCompletionSuggestions(this.getCurrentParse(), editBoxCursorPos));
                    this.getPendingSuggestions().thenRun(() -> {
                        if (this.getPendingSuggestions().isDone()) {
                            this.m_93932_();
                        }
                    });
                }
            }
        } else {
            String editBoxSubValue = editBoxValue.substring(0, editBoxCursorPos);
            int lastWordIndex = EditBoxSuggestions.m_93912_(editBoxSubValue);
            Collection<String> suggestionStringList = new ArrayList<String>(this.customSuggestionsList);
            if (suggestionStringList.isEmpty() && this.minecraft.f_91074_ != null) {
                suggestionStringList = this.minecraft.f_91074_.f_108617_.m_105137_().m_5982_();
            }
            this.setPendingSuggestions(SharedSuggestionProvider.m_82970_(suggestionStringList, (SuggestionsBuilder)new SuggestionsBuilder(editBoxSubValue, lastWordIndex)));
            if (this.autoSuggestions && this.suggestionsAllowed() && ((Boolean)this.minecraft.f_91066_.m_231813_().m_231551_()).booleanValue()) {
                this.m_93930_(false);
            }
        }
    }

    public void m_93930_(boolean someNarratingRelatedBoolean) {
        Suggestions suggestions;
        if (this.getPendingSuggestions() != null && this.getPendingSuggestions().isDone() && !(suggestions = this.getPendingSuggestions().join()).isEmpty()) {
            List<Suggestion> sortedSuggestions = this.m_93898_(suggestions);
            int totalSuggestionsWidth = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                totalSuggestionsWidth = Math.max(totalSuggestionsWidth, this.font.m_92895_(suggestion.getText()));
            }
            int listX = Mth.m_14045_((int)this.input.m_94211_(suggestions.getRange().getStart()), (int)0, (int)(this.input.m_94211_(0) + this.input.m_94210_() - totalSuggestionsWidth));
            int listY = this.anchorToBottom ? this.screen.f_96544_ - 12 : 72;
            int listHeight = Math.min(sortedSuggestions.size(), this.suggestionLineLimit) * 12;
            if (this.renderPosition == SuggestionsRenderPosition.ABOVE_EDIT_BOX) {
                listY = this.input.f_93621_ - listHeight - 2;
            }
            if (this.renderPosition == SuggestionsRenderPosition.BELOW_EDIT_BOX) {
                listY = this.input.f_93621_ + this.input.m_93694_() + 2;
            }
            this.setSuggestions(new EditBoxSuggestionsList(listX, listY, totalSuggestionsWidth, sortedSuggestions, someNarratingRelatedBoolean));
        }
    }

    public boolean m_93888_(int keycode, int scancode, int modifiers) {
        if (!this.input.m_93696_()) {
            return false;
        }
        if (this.getSuggestions() != null && this.getSuggestions().m_93988_(keycode, scancode, modifiers)) {
            return true;
        }
        if (keycode == 258) {
            this.m_93930_(true);
            return true;
        }
        return false;
    }

    public boolean m_93884_(double $$0, double $$1, int $$2) {
        if (!this.input.m_93696_()) {
            return false;
        }
        return super.m_93884_($$0, $$1, $$2);
    }

    public boolean m_93882_(double $$0) {
        if (!this.input.m_93696_()) {
            return false;
        }
        return super.m_93882_($$0);
    }

    protected void m_93932_() {
        this.getAccessor().invokeUpdateUsageInfoFancyMenu();
    }

    protected List<Suggestion> m_93898_(Suggestions suggestions) {
        return this.getAccessor().invokeSortSuggestionsFancyMenu(suggestions);
    }

    public boolean suggestionsAllowed() {
        return this.getAccessor().getAllowSuggestionsFancyMenu();
    }

    public boolean autoSuggestionsEnabled() {
        return this.autoSuggestions;
    }

    public void setAutoSuggestionsEnabled(boolean enabled) {
        this.autoSuggestions = enabled;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public DrawableColor getNormalTextColor() {
        return this.normalTextColor;
    }

    public void setNormalTextColor(@NotNull DrawableColor normalTextColor) {
        this.normalTextColor = normalTextColor;
    }

    public DrawableColor getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(@NotNull DrawableColor selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setSuggestionsRenderPosition(@NotNull SuggestionsRenderPosition position) {
        this.renderPosition = Objects.requireNonNull(position);
    }

    @NotNull
    public SuggestionsRenderPosition getSuggestionsRenderPosition() {
        return this.renderPosition;
    }

    public void setAllowRenderUsage(boolean allow) {
        this.allowRenderUsage = allow;
    }

    public boolean isAllowRenderUsage() {
        return this.allowRenderUsage;
    }

    public void enableOnlyCustomSuggestionsMode(boolean enable) {
        this.onlyCustomSuggestions = enable;
    }

    public boolean isOnlyCustomSuggestionsMode() {
        return this.onlyCustomSuggestions;
    }

    public void setCustomSuggestions(@Nullable List<String> customSuggestions) {
        if (this.commandsOnly) {
            throw new RuntimeException("Can't set custom suggestions in commands-only mode!");
        }
        this.customSuggestionsList.clear();
        if (customSuggestions != null) {
            this.customSuggestionsList.addAll(customSuggestions);
        }
    }

    public CommandSuggestions.SuggestionsList getSuggestions() {
        return this.getAccessor().getSuggestionsFancyMenu();
    }

    public void setSuggestions(CommandSuggestions.SuggestionsList suggestions) {
        this.getAccessor().setSuggestionsFancyMenu(suggestions);
    }

    public CompletableFuture<Suggestions> getPendingSuggestions() {
        return this.getAccessor().getPendingSuggestionsFancyMenu();
    }

    public void setPendingSuggestions(CompletableFuture<Suggestions> pendingSuggestions) {
        this.getAccessor().setPendingSuggestionsFancyMenu(pendingSuggestions);
    }

    public ParseResults<SharedSuggestionProvider> getCurrentParse() {
        return this.getAccessor().getCurrentParseFancyMenu();
    }

    public void setCurrentParse(ParseResults<SharedSuggestionProvider> currentParse) {
        this.getAccessor().setCurrentParseFancyMenu(currentParse);
    }

    public boolean isKeepSuggestions() {
        return this.getAccessor().getKeepSuggestionsFancyMenu();
    }

    public IMixinCommandSuggestions getAccessor() {
        return (IMixinCommandSuggestions)((Object)this);
    }

    public List<FormattedCharSequence> getCommandUsage() {
        return this.getAccessor().getCommandUsageFancyMenu();
    }

    protected static int m_93912_(String editBoxValue) {
        if (Strings.isNullOrEmpty((String)editBoxValue)) {
            return 0;
        }
        int index = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(editBoxValue);
        while (matcher.find()) {
            index = matcher.end();
        }
        return index;
    }

    public static enum SuggestionsRenderPosition {
        VANILLA,
        ABOVE_EDIT_BOX,
        BELOW_EDIT_BOX;

    }

    public class EditBoxSuggestionsList
    extends CommandSuggestions.SuggestionsList {
        protected List<Suggestion> suggestionList;

        public EditBoxSuggestionsList(int x, int y, int width, List<Suggestion> suggestionList, boolean someNarratingRelatedBoolean) {
            super((CommandSuggestions)EditBoxSuggestions.this, x, y, width, suggestionList, someNarratingRelatedBoolean);
            this.suggestionList = suggestionList;
        }

        public void m_93979_(@NotNull PoseStack pose, int mouseX, int mouseY) {
            Message message;
            boolean bl4;
            int suggestionLineCount = Math.min(this.suggestionList.size(), EditBoxSuggestions.this.suggestionLineLimit);
            boolean bl = this.getOffset() > 0;
            boolean bl2 = this.suggestionList.size() > this.getOffset() + suggestionLineCount;
            boolean bl3 = bl || bl2;
            boolean bl5 = bl4 = this.getLastMouse().f_82470_ != (float)mouseX || this.getLastMouse().f_82471_ != (float)mouseY;
            if (bl4) {
                this.setLastMouse(new Vec2((float)mouseX, (float)mouseY));
            }
            if (bl3) {
                int m;
                GuiComponent.m_93172_((PoseStack)pose, (int)this.getRect().m_110085_(), (int)(this.getRect().m_110086_() - 1), (int)(this.getRect().m_110085_() + this.getRect().m_110090_()), (int)this.getRect().m_110086_(), (int)EditBoxSuggestions.this.backgroundColor.getColorInt());
                GuiComponent.m_93172_((PoseStack)pose, (int)this.getRect().m_110085_(), (int)(this.getRect().m_110086_() + this.getRect().m_110091_()), (int)(this.getRect().m_110085_() + this.getRect().m_110090_()), (int)(this.getRect().m_110086_() + this.getRect().m_110091_() + 1), (int)EditBoxSuggestions.this.backgroundColor.getColorInt());
                if (bl) {
                    for (m = 0; m < this.getRect().m_110090_(); ++m) {
                        if (m % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pose, (int)(this.getRect().m_110085_() + m), (int)(this.getRect().m_110086_() - 1), (int)(this.getRect().m_110085_() + m + 1), (int)this.getRect().m_110086_(), (int)-1);
                    }
                }
                if (bl2) {
                    for (m = 0; m < this.getRect().m_110090_(); ++m) {
                        if (m % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pose, (int)(this.getRect().m_110085_() + m), (int)(this.getRect().m_110086_() + this.getRect().m_110091_()), (int)(this.getRect().m_110085_() + m + 1), (int)(this.getRect().m_110086_() + this.getRect().m_110091_() + 1), (int)-1);
                    }
                }
            }
            boolean bl52 = false;
            for (int n = 0; n < suggestionLineCount; ++n) {
                Suggestion suggestion = this.suggestionList.get(n + this.getOffset());
                GuiComponent.m_93172_((PoseStack)pose, (int)this.getRect().m_110085_(), (int)(this.getRect().m_110086_() + 12 * n), (int)(this.getRect().m_110085_() + this.getRect().m_110090_()), (int)(this.getRect().m_110086_() + 12 * n + 12), (int)EditBoxSuggestions.this.backgroundColor.getColorInt());
                if (mouseX > this.getRect().m_110085_() && mouseX < this.getRect().m_110085_() + this.getRect().m_110090_() && mouseY > this.getRect().m_110086_() + 12 * n && mouseY < this.getRect().m_110086_() + 12 * n + 12) {
                    if (bl4) {
                        this.m_93986_(n + this.getOffset());
                    }
                    bl52 = true;
                }
                if (EditBoxSuggestions.this.textShadow) {
                    EditBoxSuggestions.this.font.m_92750_(pose, suggestion.getText(), (float)(this.getRect().m_110085_() + 1), (float)(this.getRect().m_110086_() + 2 + 12 * n), n + this.getOffset() == this.getCurrent() ? EditBoxSuggestions.this.selectedTextColor.getColorInt() : EditBoxSuggestions.this.normalTextColor.getColorInt());
                    continue;
                }
                EditBoxSuggestions.this.font.m_92883_(pose, suggestion.getText(), (float)(this.getRect().m_110085_() + 1), (float)(this.getRect().m_110086_() + 2 + 12 * n), n + this.getOffset() == this.getCurrent() ? EditBoxSuggestions.this.selectedTextColor.getColorInt() : EditBoxSuggestions.this.normalTextColor.getColorInt());
            }
            if (bl52 && (message = this.suggestionList.get(this.getCurrent()).getTooltip()) != null) {
                EditBoxSuggestions.this.screen.m_96602_(pose, ComponentUtils.m_130729_((Message)message), mouseX, mouseY);
            }
        }

        public Rect2i getRect() {
            return this.getAccessor().getRectFancyMenu();
        }

        public int getOffset() {
            return this.getAccessor().getOffsetFancyMenu();
        }

        public int getCurrent() {
            return this.getAccessor().getCurrentFancyMenu();
        }

        public Vec2 getLastMouse() {
            return this.getAccessor().getLastMouseFancyMenu();
        }

        public void setLastMouse(Vec2 lastMouse) {
            this.getAccessor().setLastMouseFancyMenu(lastMouse);
        }

        public IMixinSuggestionsList getAccessor() {
            return (IMixinSuggestionsList)((Object)this);
        }
    }
}

