/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class ExtendedSliderButton
extends AbstractSliderButton
implements UniqueWidget,
NavigatableWidget,
FancyMenuWidget {
    protected static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("textures/gui/slider.png");
    protected static boolean leftDownGlobal = false;
    public boolean handleClick;
    public boolean enableRightClick = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreGlobalLeftMouseDown = false;
    protected String messagePrefix = null;
    protected String messageSuffix = null;
    protected Consumer<ExtendedSliderButton> applyValueCallback;
    @Nullable
    protected DrawableColor backgroundColor = null;
    @Nullable
    protected DrawableColor borderColor = null;
    @Nullable
    protected DrawableColor handleColorNormal = null;
    @Nullable
    protected DrawableColor handleColorHover = null;
    @NotNull
    protected DrawableColor labelColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    @NotNull
    protected DrawableColor labelColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @Nullable
    protected String identifier;
    protected boolean focusable = true;
    protected boolean navigatable = true;
    protected boolean leftDownNotHovered = false;
    protected boolean leftDownThis = false;

    @Deprecated
    public ExtendedSliderButton(int x, int y, int width, int height, boolean handleClick, double value, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, CommonComponents.f_237098_, value);
        this.handleClick = handleClick;
        this.applyValueCallback = applyValueCallback;
    }

    public int getX() {
        return this.f_93620_;
    }

    public void setX(int x) {
        this.f_93620_ = x;
    }

    public int getY() {
        return this.f_93621_;
    }

    public void setY(int y) {
        this.f_93621_ = y;
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public void m_93674_(int width) {
        this.f_93618_ = width;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(graphics);
        this.renderHandle(graphics);
        int labelColorInt = this.f_93623_ ? this.labelColorNormal.getColorInt() : this.labelColorInactive.getColorInt();
        this.renderScrollingLabel(graphics, Minecraft.m_91087_().f_91062_, 2, labelColorInt | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderHandle(@NotNull GuiGraphics graphics) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int handleX = this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
        DrawableColor c = this.getHandleRenderColor();
        if (c == null) {
            graphics.setColor(1.0f, 1.0f, 1.0f, this.f_93625_);
            graphics.blitNineSliced(SLIDER_LOCATION, handleX, this.f_93621_, 8, 20, 20, 4, 200, 20, 0, this.getHandleTextureY());
        } else {
            graphics.fill(handleX, this.f_93621_, handleX + 8, this.f_93621_ + this.m_93694_(), RenderingUtils.replaceAlphaInColor(c.getColorInt(), this.f_93625_));
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    @Nullable
    protected DrawableColor getHandleRenderColor() {
        if (this.f_93622_ && this.handleColorHover != null) {
            return this.handleColorHover;
        }
        return this.handleColorNormal;
    }

    protected void renderBackground(@NotNull GuiGraphics graphics) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        if (this.backgroundColor == null) {
            graphics.setColor(1.0f, 1.0f, 1.0f, this.f_93625_);
            graphics.blitNineSliced(SLIDER_LOCATION, this.f_93620_, this.f_93621_, this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getTextureY());
        } else {
            int borderOffset = this.borderColor != null ? 1 : 0;
            graphics.fill(this.f_93620_ + borderOffset, this.f_93621_ + borderOffset, this.f_93620_ + this.m_5711_() - borderOffset, this.f_93621_ + this.m_93694_() - borderOffset, RenderingUtils.replaceAlphaInColor(this.backgroundColor.getColorInt(), this.f_93625_));
            if (this.borderColor != null) {
                UIBase.renderBorder(graphics, this.f_93620_, this.f_93621_, this.f_93620_ + this.m_5711_(), this.f_93621_ + this.m_93694_(), 1, this.borderColor, true, true, true, true);
            }
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            boolean bl = this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            if (!this.m_198029_() && MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = false;
            }
            if (this.handleClick) {
                if (this.m_198029_() && (MouseInput.isLeftMouseDown() || this.enableRightClick && MouseInput.isRightMouseDown()) && (!leftDownGlobal || this.ignoreGlobalLeftMouseDown) && !this.leftDownNotHovered && !this.isInputBlocked() && this.f_93623_ && this.f_93624_ && !this.leftDownThis) {
                    this.m_5716_(mouseX, mouseY);
                    leftDownGlobal = true;
                    this.leftDownThis = true;
                }
                if (!(MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown() && this.enableRightClick)) {
                    leftDownGlobal = false;
                    if (this.leftDownThis) {
                        this.m_7691_(mouseX, mouseY);
                    }
                    this.leftDownThis = false;
                }
                if (this.leftDownThis) {
                    this.m_7212_(mouseX, mouseY, 0.0, 0.0);
                }
            }
        }
        super.m_6305_(graphics.pose(), mouseX, mouseY, partial);
        this.renderWidget(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    @Deprecated
    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        this.render(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    protected void renderScrollingLabel(@NotNull GuiGraphics graphics, @NotNull Font font, int spaceLeftRight, int textColor) {
        int xMin = this.f_93620_ + spaceLeftRight;
        int xMax = this.f_93620_ + this.m_5711_() - spaceLeftRight;
        this.renderScrollingLabelInternal(graphics, font, this.m_6035_(), xMin, this.f_93621_, xMax, this.f_93621_ + this.m_93694_(), textColor);
    }

    protected void renderScrollingLabelInternal(@NotNull GuiGraphics graphics, Font font, @NotNull Component text, int xMin, int yMin, int xMax, int yMax, int textColor) {
        int textWidth = font.m_92852_((FormattedText)text);
        int textPosY = (yMin + yMax - 9) / 2 + 1;
        int maxTextWidth = xMax - xMin;
        if (textWidth > maxTextWidth) {
            int diffTextWidth = textWidth - maxTextWidth;
            double scrollTime = (double)Util.m_137550_() / 1000.0;
            double $$13 = Math.max((double)diffTextWidth * 0.5, 3.0);
            double $$14 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * scrollTime / $$13)) / 2.0 + 0.5;
            double textPosX = Mth.m_14139_((double)$$14, (double)0.0, (double)diffTextWidth);
            graphics.enableScissor(xMin, yMin, xMax, yMax);
            graphics.drawString(font, text, xMin - (int)textPosX, textPosY, textColor, this.labelShadow);
            graphics.disableScissor();
        } else {
            graphics.drawString(font, text, (int)((float)(xMin + xMax) / 2.0f - (float)font.m_92852_((FormattedText)text) / 2.0f), textPosY, textColor, this.labelShadow);
        }
    }

    @Nullable
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@Nullable DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Nullable
    public DrawableColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@Nullable DrawableColor borderColor) {
        this.borderColor = borderColor;
    }

    @Nullable
    public DrawableColor getHandleColorNormal() {
        return this.handleColorNormal;
    }

    public void setHandleColorNormal(@Nullable DrawableColor handleColorNormal) {
        this.handleColorNormal = handleColorNormal;
    }

    @Nullable
    public DrawableColor getHandleColorHover() {
        return this.handleColorHover;
    }

    public void setHandleColorHover(@Nullable DrawableColor handleColorHover) {
        this.handleColorHover = handleColorHover;
    }

    @NotNull
    public DrawableColor getLabelColorNormal() {
        return this.labelColorNormal;
    }

    public void setLabelColorNormal(@NotNull DrawableColor labelColorNormal) {
        this.labelColorNormal = labelColorNormal;
    }

    @NotNull
    public DrawableColor getLabelColorInactive() {
        return this.labelColorInactive;
    }

    public void setLabelColorInactive(@NotNull DrawableColor labelColorInactive) {
        this.labelColorInactive = labelColorInactive;
    }

    public boolean isLabelShadow() {
        return this.labelShadow;
    }

    public void setLabelShadow(boolean labelShadow) {
        this.labelShadow = labelShadow;
    }

    public boolean canChangeValue() {
        return true;
    }

    protected int getTextureY() {
        int $$0 = this.m_93696_() && !this.canChangeValue() ? 1 : 0;
        return $$0 * 20;
    }

    protected int getHandleTextureY() {
        int $$0 = !this.f_93622_ && !this.canChangeValue() ? 2 : 3;
        return $$0 * 20;
    }

    protected void m_7212_(double mouseX, double mouseY, double d1, double d2) {
        super.m_7212_(mouseX, mouseY, d1, d2);
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
    }

    protected void m_5697_() {
        if (this.applyValueCallback != null) {
            this.applyValueCallback.accept(this);
        }
    }

    public void m_5695_() {
        Object s = "";
        if (this.messagePrefix != null) {
            s = (String)s + this.messagePrefix;
        }
        s = (String)s + this.getSliderMessageWithoutPrefixSuffix();
        if (this.messageSuffix != null) {
            s = (String)s + this.messageSuffix;
        }
        this.m_93666_((Component)Component.m_237113_((String)s));
    }

    public abstract String getSliderMessageWithoutPrefixSuffix();

    public void setLabelPrefix(String prefix) {
        this.messagePrefix = prefix;
        this.m_5695_();
    }

    public void setLabelSuffix(String suffix) {
        this.messageSuffix = suffix;
        this.m_5695_();
    }

    public void m_93611_(double value) {
        double d0 = this.f_93577_;
        this.f_93577_ = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (d0 != this.f_93577_) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    public double getValue() {
        return this.f_93577_;
    }

    protected boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public ExtendedSliderButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    public void m_93692_(boolean focused) {
        if (!this.focusable) {
            super.m_93692_(false);
            return;
        }
        super.m_93692_(focused);
    }

    public boolean m_93696_() {
        if (!this.focusable) {
            return false;
        }
        return super.m_93696_();
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }
}

