/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.VanillaTooltip;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.IExtendedWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.WidgetWithVanillaTooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExtendedSlider
extends AbstractSliderButton
implements IExtendedWidget,
NavigatableWidget,
FancyMenuWidget,
WidgetWithVanillaTooltip {
    @Nullable
    protected DrawableColor sliderBackgroundColorNormal;
    @Nullable
    protected DrawableColor sliderBackgroundColorHighlighted;
    @Nullable
    protected DrawableColor sliderBorderColorNormal;
    @Nullable
    protected DrawableColor sliderBorderColorHighlighted;
    @Nullable
    protected DrawableColor sliderHandleColorNormal;
    @Nullable
    protected DrawableColor sliderHandleColorHover;
    @Nullable
    protected DrawableColor sliderHandleColorInactive;
    @NotNull
    protected DrawableColor labelColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    @NotNull
    protected DrawableColor labelColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @Nullable
    protected SliderValueUpdateListener sliderValueUpdateListener;
    @NotNull
    protected ConsumingSupplier<AbstractExtendedSlider, Component> labelSupplier = slider -> Component.m_237113_((String)slider.getValueDisplayText());
    protected boolean focusable = true;
    protected boolean navigatable = true;
    @Nullable
    protected ConsumingSupplier<AbstractExtendedSlider, Boolean> isActiveSupplier = null;
    protected boolean leftMouseDown = false;
    @Nullable
    protected VanillaTooltip vanillaTooltip;

    public AbstractExtendedSlider(int x, int y, int width, int height, Component label, double value) {
        super(x, y, width, height, label, value);
    }

    public int getX() {
        return this.f_93620_;
    }

    public void setX(int x) {
        this.f_93620_ = x;
    }

    public int getY() {
        return this.f_93621_;
    }

    public void setY(int y) {
        this.f_93621_ = y;
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public void m_93674_(int width) {
        this.f_93618_ = width;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public void m_6303_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        GuiGraphics graphics = GuiGraphics.currentGraphics();
        this.renderBackground(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
        this.renderHandle(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
        this.renderLabel(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.isActiveSupplier != null) {
            this.f_93623_ = this.isActiveSupplier.get(this);
        }
        super.m_6305_(graphics.pose(), mouseX, mouseY, partial);
    }

    @Deprecated
    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        this.render(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    protected void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        boolean renderVanilla = this.renderColorBackground(graphics, mouseX, mouseY, partial);
        if (renderVanilla) {
            renderVanilla = this.getAsCustomizableSlider().renderSliderBackgroundFancyMenu(graphics, this, true);
        }
        if (renderVanilla) {
            this.renderVanillaBackground(graphics, mouseX, mouseY, partial);
        }
    }

    protected boolean renderColorBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor(graphics);
        if (this.sliderBackgroundColorNormal != null) {
            graphics.fill(this.f_93620_, this.f_93621_, this.f_93620_ + this.m_5711_(), this.f_93621_ + this.m_93694_(), this.sliderBackgroundColorNormal.getColorInt());
            if (this.sliderBorderColorNormal != null) {
                UIBase.renderBorder(graphics, (float)this.f_93620_, (float)this.f_93621_, (float)(this.f_93620_ + this.m_5711_()), (float)(this.f_93621_ + this.m_93694_()), 1.0f, this.sliderBorderColorNormal.getColorInt(), true, true, true, true);
            }
            return false;
        }
        return true;
    }

    protected void renderVanillaBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.setColor(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        graphics.blitNineSliced(f_93617_, this.f_93620_, this.f_93621_, this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getBackgroundTextureY());
        RenderingUtils.resetShaderColor(graphics);
    }

    protected int getBackgroundTextureY() {
        return 46;
    }

    protected void renderHandle(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        boolean renderVanilla = this.renderColorHandle(graphics, mouseX, mouseY, partial);
        if (renderVanilla) {
            renderVanilla = this.getAsCustomizableWidget().renderCustomBackgroundFancyMenu((AbstractWidget)this, graphics, this.getHandleX(), this.f_93621_, this.getHandleWidth(), this.m_93694_());
        }
        if (renderVanilla) {
            this.renderVanillaHandle(graphics, mouseX, mouseY, partial);
        }
    }

    protected boolean renderColorHandle(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.m_69478_();
        int handleX = this.getHandleX();
        int handleWidth = this.getHandleWidth();
        if (this.f_93623_) {
            if (this.m_198029_()) {
                if (this.sliderHandleColorHover != null) {
                    graphics.fill(handleX, this.f_93621_, handleX + handleWidth, this.f_93621_ + this.m_93694_(), this.sliderHandleColorHover.getColorInt());
                    return false;
                }
            } else if (this.sliderHandleColorNormal != null) {
                graphics.fill(handleX, this.f_93621_, handleX + handleWidth, this.f_93621_ + this.m_93694_(), this.sliderHandleColorNormal.getColorInt());
                return false;
            }
        } else if (this.sliderHandleColorInactive != null) {
            graphics.fill(handleX, this.f_93621_, handleX + handleWidth, this.f_93621_ + this.m_93694_(), this.sliderHandleColorInactive.getColorInt());
            return false;
        }
        return true;
    }

    protected void renderVanillaHandle(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.setColor(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        graphics.blitNineSliced(f_93617_, this.getSliderHandleX(), this.f_93621_, this.getHandleWidth(), this.m_93694_(), 20, 4, 200, 20, 0, this.getHandleTextureY());
        RenderingUtils.resetShaderColor(graphics);
    }

    protected int getSliderHandleX() {
        return this.f_93620_ + (int)(this.f_93577_ * (double)(this.m_5711_() - this.getHandleWidth()));
    }

    protected int getHandleTextureY() {
        int i = 1;
        if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    protected void renderLabel(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        int textColor = this.f_93623_ ? this.labelColorNormal.getColorInt() : this.labelColorInactive.getColorInt();
        this.renderScrollingLabel((AbstractWidget)this, graphics, Minecraft.m_91087_().f_91062_, 2, this.labelShadow, RenderingUtils.replaceAlphaInColor(textColor, this.f_93625_));
    }

    public int getHandleX() {
        return this.f_93620_ + (int)(this.f_93577_ * (double)(this.m_5711_() - this.getHandleWidth()));
    }

    public int getHandleWidth() {
        return 8;
    }

    public void m_5695_() {
        Component label = this.labelSupplier.get(this);
        if (label == null) {
            label = Component.m_237119_();
        }
        this.m_93666_(label);
    }

    protected void m_5697_() {
        if (this.sliderValueUpdateListener != null) {
            this.sliderValueUpdateListener.update(this, this.getValueDisplayText(), this.f_93577_);
        }
    }

    @NotNull
    public abstract String getValueDisplayText();

    public AbstractExtendedSlider setSliderValueUpdateListener(@Nullable SliderValueUpdateListener listener) {
        this.sliderValueUpdateListener = listener;
        this.m_5695_();
        return this;
    }

    public void m_93611_(double value) {
        double d0 = this.f_93577_;
        this.f_93577_ = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (d0 != this.f_93577_) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    public double getValue() {
        return this.f_93577_;
    }

    public AbstractExtendedSlider setIsActiveSupplier(@Nullable ConsumingSupplier<AbstractExtendedSlider, Boolean> supplier) {
        this.isActiveSupplier = supplier;
        return this;
    }

    @Nullable
    public RenderableResource getHandleTextureNormal() {
        return this.getAsCustomizableWidget().getCustomBackgroundNormalFancyMenu();
    }

    public AbstractExtendedSlider setHandleTextureNormal(@Nullable RenderableResource texture) {
        this.getAsCustomizableWidget().setCustomBackgroundNormalFancyMenu(texture);
        return this;
    }

    @Nullable
    public RenderableResource getHandleTextureHover() {
        return this.getAsCustomizableWidget().getCustomBackgroundHoverFancyMenu();
    }

    public AbstractExtendedSlider setHandleTextureHover(@Nullable RenderableResource texture) {
        this.getAsCustomizableWidget().setCustomBackgroundHoverFancyMenu(texture);
        return this;
    }

    @Nullable
    public RenderableResource getHandleTextureInactive() {
        return this.getAsCustomizableWidget().getCustomBackgroundInactiveFancyMenu();
    }

    public AbstractExtendedSlider setHandleTextureInactive(@Nullable RenderableResource texture) {
        this.getAsCustomizableWidget().setCustomBackgroundInactiveFancyMenu(texture);
        return this;
    }

    @Nullable
    public RenderableResource getBackgroundTextureNormal() {
        return this.getAsCustomizableSlider().getCustomSliderBackgroundNormalFancyMenu();
    }

    public AbstractExtendedSlider setBackgroundTextureNormal(@Nullable RenderableResource texture) {
        this.getAsCustomizableSlider().setCustomSliderBackgroundNormalFancyMenu(texture);
        return this;
    }

    @Nullable
    public RenderableResource getBackgroundTextureHighlighted() {
        return this.getAsCustomizableSlider().getCustomSliderBackgroundHighlightedFancyMenu();
    }

    public AbstractExtendedSlider setBackgroundTextureHighlighted(@Nullable RenderableResource texture) {
        this.getAsCustomizableSlider().setCustomSliderBackgroundHighlightedFancyMenu(texture);
        return this;
    }

    @Nullable
    public DrawableColor getSliderBackgroundColorNormal() {
        return this.sliderBackgroundColorNormal;
    }

    public AbstractExtendedSlider setSliderBackgroundColorNormal(@Nullable DrawableColor sliderBackgroundColorNormal) {
        this.sliderBackgroundColorNormal = sliderBackgroundColorNormal;
        return this;
    }

    @Nullable
    public DrawableColor getSliderBackgroundColorHighlighted() {
        return this.sliderBackgroundColorHighlighted;
    }

    public AbstractExtendedSlider setSliderBackgroundColorHighlighted(@Nullable DrawableColor sliderBackgroundColorHighlighted) {
        this.sliderBackgroundColorHighlighted = sliderBackgroundColorHighlighted;
        return this;
    }

    @Nullable
    public DrawableColor getSliderBorderColorNormal() {
        return this.sliderBorderColorNormal;
    }

    public AbstractExtendedSlider setSliderBorderColorNormal(@Nullable DrawableColor sliderBorderColorNormal) {
        this.sliderBorderColorNormal = sliderBorderColorNormal;
        return this;
    }

    @Nullable
    public DrawableColor getSliderBorderColorHighlighted() {
        return this.sliderBorderColorHighlighted;
    }

    public AbstractExtendedSlider setSliderBorderColorHighlighted(@Nullable DrawableColor sliderBorderColorHighlighted) {
        this.sliderBorderColorHighlighted = sliderBorderColorHighlighted;
        return this;
    }

    @Nullable
    public DrawableColor getSliderHandleColorNormal() {
        return this.sliderHandleColorNormal;
    }

    public AbstractExtendedSlider setSliderHandleColorNormal(@Nullable DrawableColor sliderHandleColorNormal) {
        this.sliderHandleColorNormal = sliderHandleColorNormal;
        return this;
    }

    @Nullable
    public DrawableColor getSliderHandleColorHover() {
        return this.sliderHandleColorHover;
    }

    public AbstractExtendedSlider setSliderHandleColorHover(@Nullable DrawableColor sliderHandleColorHover) {
        this.sliderHandleColorHover = sliderHandleColorHover;
        return this;
    }

    @Nullable
    public DrawableColor getSliderHandleColorInactive() {
        return this.sliderHandleColorInactive;
    }

    public AbstractExtendedSlider setSliderHandleColorInactive(@Nullable DrawableColor sliderHandleColorInactive) {
        this.sliderHandleColorInactive = sliderHandleColorInactive;
        return this;
    }

    @NotNull
    public DrawableColor getLabelColorNormal() {
        return this.labelColorNormal;
    }

    public AbstractExtendedSlider setLabelColorNormal(@NotNull DrawableColor labelColorNormal) {
        this.labelColorNormal = labelColorNormal;
        return this;
    }

    @NotNull
    public DrawableColor getLabelColorInactive() {
        return this.labelColorInactive;
    }

    public AbstractExtendedSlider setLabelColorInactive(@NotNull DrawableColor labelColorInactive) {
        this.labelColorInactive = labelColorInactive;
        return this;
    }

    public boolean isLabelShadow() {
        return this.labelShadow;
    }

    public AbstractExtendedSlider setLabelShadow(boolean labelShadow) {
        this.labelShadow = labelShadow;
        return this;
    }

    @NotNull
    public ConsumingSupplier<AbstractExtendedSlider, Component> getLabelSupplier() {
        return this.labelSupplier;
    }

    public AbstractExtendedSlider setLabelSupplier(@NotNull ConsumingSupplier<AbstractExtendedSlider, Component> labelSupplier) {
        this.labelSupplier = labelSupplier;
        return this;
    }

    public CustomizableSlider getAsCustomizableSlider() {
        return (CustomizableSlider)((Object)this);
    }

    public CustomizableWidget getAsCustomizableWidget() {
        return (CustomizableWidget)((Object)this);
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.canClick()) {
            return false;
        }
        if (button == 0) {
            this.leftMouseDown = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.leftMouseDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.leftMouseDown) {
            return false;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean canClick() {
        return this.f_93622_ && this.m_142518_() && this.f_93624_;
    }

    public boolean isHovered() {
        return this.f_93622_;
    }

    @Override
    @Nullable
    public VanillaTooltip getVanillaTooltip_FancyMenu() {
        return this.vanillaTooltip;
    }

    @Override
    public void setVanillaTooltip_FancyMenu(@Nullable VanillaTooltip tooltip) {
        this.vanillaTooltip = tooltip;
    }

    @FunctionalInterface
    public static interface SliderValueUpdateListener {
        public void update(@NotNull AbstractExtendedSlider var1, @NotNull String var2, double var3);
    }
}

