package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.layout.command.LayoutCommandPacket;
import de.keksuccino.konkrete.command.CommandUtils;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class LayoutCommand {

    public static final Map<String, List<String>> CACHED_LAYOUT_SUGGESTIONS = Collections.synchronizedMap(new HashMap<>());

    public static void register(CommandDispatcher<class_2168> d) {
        d.register(class_2170.method_9247("fmlayout").then(class_2170.method_9244("layout_name", StringArgumentType.string())
                .suggests((context, provider) -> {
                    return CommandUtils.getStringSuggestions(provider, getLayoutNameSuggestions(context.getSource().method_9207()));
                })
                .then(class_2170.method_9244("is_layout_enabled", BoolArgumentType.bool())
                        .executes(context -> {
                            return setLayoutState(context.getSource(), StringArgumentType.getString(context, "layout_name"), BoolArgumentType.getBool(context, "is_layout_enabled"), null);
                        })
                        .then(class_2170.method_9244("target_players", class_2186.method_9308())
                                .requires(context -> context.method_9259(2))
                                .executes(context -> {
                                    return setLayoutState(context.getSource(), StringArgumentType.getString(context, "layout_name"), BoolArgumentType.getBool(context, "is_layout_enabled"), class_2186.method_9312(context, "target_players"));
                                })))
        ));
    }

    private static String[] getLayoutNameSuggestions(class_3222 sender) {
        List<String> l = new ArrayList<>(Objects.requireNonNullElse(CACHED_LAYOUT_SUGGESTIONS.get(sender.method_5667().toString()), new ArrayList<>()));
        if (l.isEmpty()) {
            l.add("<no_layouts_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int setLayoutState(class_2168 stack, String layoutName, boolean enabled, @Nullable Collection<class_3222> targets) {
        try {
            if (targets == null) {
                class_3222 sender = stack.method_9207();
                LayoutCommandPacket packet = new LayoutCommandPacket();
                packet.layout_name = layoutName;
                packet.enabled = enabled;
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (class_3222 target : targets) {
                    LayoutCommandPacket packet = new LayoutCommandPacket();
                    packet.layout_name = layoutName;
                    packet.enabled = enabled;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        } catch (Exception ex) {
            stack.method_9213(class_2561.method_43470("Error while executing /fmlayout command!"));
            ex.printStackTrace();
        }
        return 1;
    }

}