package de.keksuccino.fancymenu.customization.action;

import de.keksuccino.fancymenu.customization.action.ui.AsyncActionErrorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableScreenHandler;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

/**
 * An action to use with buttons, tickers, etc.<br>
 * Needs to get registered to the {@link ActionRegistry} at mod init.
 */
public abstract class Action {

    public static final Action EMPTY = new Action("empty") {@Override public boolean hasValue() {return false;}@Override public void execute(@Nullable String value) {}@Override public @NotNull class_2561 getActionDisplayName() {return class_2561.method_43473();}@Override public @NotNull class_2561[] getActionDescription() {return new class_2561[0];}@Override public @Nullable class_2561 getValueDisplayName() {return null;}@Override public @Nullable String getValueExample() {return null;}};

    private final String identifier;
    @Nullable
    protected ActionInstance currentInstance = null;
    protected volatile boolean asyncErrorShown = false;

    public Action(@NotNull String uniqueIdentifier) {
        this.identifier = Objects.requireNonNull(uniqueIdentifier);
    }

    public boolean isDeprecated() {
        return false;
    }

    /**
     * This lets you control if it should be possible to add a new instance of this action type to a layout.<br>
     * For example, by using this you can control if the action should only be available for specific types of {@link class_437}s.
     */
    public boolean shouldShowUpInEditorActionMenu(@NotNull LayoutEditorScreen editor) {
        return true;
    }

    /**
     * If this action has a value.
     */
    public abstract boolean hasValue();

    /**
     * @param value The value that was set to the action or NULL if this action has no value.
     */
    public abstract void execute(@Nullable String value);

    @NotNull
    public abstract class_2561 getActionDisplayName();

    @NotNull
    public abstract class_2561[] getActionDescription();

    @Nullable
    public abstract class_2561 getValueDisplayName();

    /**
     * An example of how the value of this action should look like.
     */
    @Nullable
    public abstract String getValueExample();

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        if (this.hasValue()) {
            TextEditorScreen s = new TextEditorScreen(this.getValueDisplayName(), null, (call) -> {
                if (call != null) {
                    instance.value = call;
                }
                class_310.method_1551().method_1507(parentScreen);
            });
            List<TextEditorFormattingRule> formattingRules = this.getValueFormattingRules();
            if (formattingRules != null) s.formattingRules.addAll(formattingRules);
            s.setMultilineMode(false);
            if (instance.value != null) {
                s.setText(instance.value);
            } else {
                s.setText(this.getValueExample());
            }
            class_310.method_1551().method_1507(s);
        }
    }

    public boolean canRunAsync() {
        return true;
    }

    public boolean checkAsync() {
        boolean sameThread = class_310.method_1551().method_18854();
        if (!sameThread && !this.canRunAsync() && !this.asyncErrorShown) {
            this.asyncErrorShown = true;
            QueueableScreenHandler.addToQueue(new AsyncActionErrorScreen(this.getActionDisplayName()));
        }
        return this.canRunAsync() || sameThread; // should run action
    }

}
